package util;

/**
 * TestApplet class.
 *
 * Takes several arguments defining the context in which to load a class
 * using AppletClassLoader.
 *
 * Then it will apply to this class the given <Test> with the given <args...>
 */

import java.net.*;
import sun.applet.*;
import java.util.*;
import java.io.*;

public class TestApplet extends Util {
    private static void usage() {
	error("usage: "+listBaseOptions()+
	      " <URL for CodeBase> [-jar <URL for JAR>]* <ClassName> <TestName> <args>...");
	explainBaseOptions();
	error(" The <URL for CodeBase> must end in '/'");
	error(" If <ClassName>'s class supports the util.Check interface,");
	error("    that interface will be used, thus placing the ClassLoader of");
	error("    <ClassName> in the call stack");
    }

    private static void ensure(String args[], int i) {
	if (args.length < i) {
	    usage();
	    System.exit(1);
	}
    }

    private static String[] doJarArgs(String args[], Vector v) {
	ensure(args, 1);
	while (args[0].equals("-jar")) {
	    ensure(args, 2);
	    v.addElement(args[1]);
	    args = shiftArgs(args, 2);
	}
	return args;
    }

    private static void adjustProperties() {
	Properties p = System.getProperties();
	Properties p2;
	p2 = new Properties(p);
	try {
	    InputStream is = new FileInputStream("test.properties");
	    p2.load(is);
	} catch (Exception ex) {
	    System.err.println("caught an exception "+ex);
	}
	System.setProperties(p2);
	String s = System.getProperty("applet.allow.namespace");
	System.err.println("applet.allow.namespace is "+s);
    }

    public static void main(String args[]) {
	// Set applet.allow.namespace
	adjustProperties();

	// Base options
	ensure(args, 1);
	args = doBaseOptions(args);

	// CodeBase
	ensure(args, 1);
	String codeBaseName = args[0];
	if (! codeBaseName.endsWith("/")) {
	    usage();
	    System.exit(1);
	}
	args = shiftArgs(args);

	// JarNames
	String jarNames[];
	Vector tmp = new Vector();
	args = doJarArgs(args, tmp);
	jarNames = new String[tmp.size()];
	tmp.copyInto(jarNames);

	// ClassName
	ensure(args, 1);
	String className = args[0];
	args = shiftArgs(args, 1);

	// TestName
	ensure(args, 1);
	String testName = args[0];
	args = shiftArgs(args, 1);

	//Create and install the security manager
	System.setSecurityManager(new AppletSecurity());

	// print test header
	print("TestApplet::");
	print(" codebase: "+codeBaseName);
	if (jarNames.length > 0) {
	    print(" JARs: ",jarNames);
	}
	print(" test: "+testName);
	print1(" class: "+className);
	print1(" args: ", args);
	print1(" Security Manager: "+System.getSecurityManager());

	URL codeBase;
	try {
	    codeBase = new URL(codeBaseName);
	    TestClassLoader cl = new TestClassLoader(codeBase);
	    AppletResourceLoader rl = cl.getResourceLoader();
	    for (int i=0; i < jarNames.length; i++) {
		debug("loading JAR "+jarNames[i]);
		sun.applet.Tunnel.loadJar(rl, codeBase, jarNames[i]);
	    }
	    debug("loading class "+className);
	    Class k = cl.loadClass(className);
	    Test theTest = (Test) Class.forName(testName).newInstance();
	    theTest.run(k, args);
	} catch (Exception ex) {
	    error("caught "+ex);
	    System.exit(1);
	}
	if (getKill()) {
	    System.exit(0);
	}
    }

    static class TestClassLoader extends AppletClassLoader {
	public TestClassLoader(URL base) {
	    super(base);
	}
    }

}
