package util;

/**
 * TestSystem class.
 *
 * Loads a class using the System ClassLoader
 */

import java.net.*;
import sun.applet.*;

public class TestSystem extends Util {
    private static void usage() {
	error("usage: "+listBaseOptions()+
	      " <ClassName> <TestName> <args>...");
	explainBaseOptions();
	error(" If <ClassName>'s class supports the util.Check interface,");
	error("    that interface will be used, thus placing the ClassLoader of");
	error("    <ClassName> in the call stack");
    }

    private static void ensure(String args[], int i) {
	if (args.length < i) {
	    usage();
	    System.exit(1);
	}
    }

    public static void main(String args[]) {
	// Base options
	ensure(args, 1);
	args = doBaseOptions(args);

	// ClassName
	ensure(args, 1);
	String className = args[0];
	args = shiftArgs(args);

	// TestName
	ensure(args, 1);
	String testName = args[0];
	args = shiftArgs(args);

	// print test header
	print("TestSystem::");
	print(" test: "+testName);
	print1(" class: "+className);
	print1(" args: ", args);
	print1(" Security Manager: "+System.getSecurityManager());

	try {
	    Class k = Class.forName(className);
	    Test theTest = (Test) Class.forName(testName).newInstance();
	    theTest.run(k, args);
	} catch (Exception ex) {
	    error("caught "+ex);
	    System.exit(1);
	}
	if (getKill()) {
	    System.exit(0);
	}
    }
}
