package util;

/**
 * Verify Conten of a resource.
 *
 * Resources should be found, readable, and getting a getContent on them
 * should yield an object that is same type as doing a getContent on an
 * alternate verification URL that is provided in the golden file.
 */

import java.io.*;
import java.net.*;
import java.util.*;

public class VerifyContent extends Util implements Test {
    public VerifyContent() {
    }

    private static void usage() {
	print("usage for Verify Content tests: <URL base> <golden file>");
	print(" <URL base> is used to prefix the alternate verification URLs,");
	print(" <URL base> should end in '/'.");
    }

    // this is the check to perform
    public void check() throws TestException {
	if (canFind(theKlass, theName)) {
	    if (isReadable(theKlass, theName)) {
		String why = contentEquals(theKlass, theName, theVerify, false);
		if (why == null) {
		    pass(theName+" found and readable.");
		} else {
		    fail(theName+why);
		}
	    } else {
		fail(theName+" found but not readable.");
	    }
	} else {
	    fail(theName+" not found.");
	}
    }

    // run this test with these arguments
    public void run(Class klass, String args[]) {
	if (args.length != 2) {
	    usage();
	    System.exit(1);
	}
	String urlBaseName = args[0];
	if (! urlBaseName.endsWith("/")) {
	    usage();
	    System.exit(1);
	}
	String fileName = args[1];
	try {
	    BufferedReader r = null;
	    URL urlBase = null;
	    try {
		urlBase = new URL(urlBaseName);
		r = new BufferedReader(new FileReader(fileName));
	    } catch (Exception ex) {
		usage();
		System.exit(1);
	    }
	    String line;
	    // Get and print the test description
	    debug("class: "+klass);
	    debug("ClassLoader: "+klass.getClassLoader());
	    debug("CurrentClassLoader: "+myCurrentClassLoader());
	    while (((line = r.readLine()) != null) &&
		   (line.length() != 0)) {
		print2(line);
	    }
	    String name;
	    String verifyName;
	    while ((line = r.readLine()) != null) {
		StringTokenizer st = new StringTokenizer(line);
		name = st.nextToken().trim();
		debug("resource to verify: "+name);
		while(st.hasMoreTokens()) {
		    verifyName = st.nextToken().trim();
		    URL verify = new URL(urlBase, verifyName);
		    debug("verify URL: "+verify);
		    theKlass = klass;
		    theName = name;
		    theVerify = verify;
		    indirect(klass);
		}
	    }

	} catch (Exception ex) {
	    fail("Caught "+ex);
	}
	reportTest();
    }

    // The arguments (this is a closure)
    Class theKlass;		// the class providing the context
    String theName;		// the name of the resource
    URL theVerify;		// URL to verify against.
}
