/*
 * @(#)ProcTest.java	1.2 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.io.*;

/*
 * Exec a process, write stdout/stderr to files
 */

public class ProcTest implements Runnable {

    public static void main(String args[]) {
	new ProcTest(args).run();
    }

    public static void p(String s) { 
	System.out.println("ProcTest: " + s); 
    } 
    
    public static void verbose(String s) {
	if (verbose)
	    p(s);
    }

    public void assert(boolean mustBeTrue, String ex) {
	try { 
	    if (!mustBeTrue) {
		System.err.println("ProcTest: Assertion failed: " + ex+", stack trace:");
		throw new Exception(ex); 
	    }
	} catch (Exception e) {
	    e.printStackTrace();
	    System.exit(1);
	}
    }

    public void fail(Exception e) {
	System.err.println("ProcTest: unexpected exception:");
	e.printStackTrace();
	System.exit(1);
    }

    ProcTest(){}

    ProcTest(String[] a) {
	args(a);
    }

    void args(String[] a) {
	try {
	    for (int i = 0; i < a.length; i++) {
		String s = a[i];
		if (s.equals("verbose")) {
		    verbose = true;
		    continue;
		} else if (s.equals("wait")) {
		    wait = true;
		    continue;
		} else if (s.equals("inFile")) {
		    inFile = a[++i];
		    continue;
		} else if (s.equals("outFile")) {
		    outFile = a[++i];
		    continue;
		} else if (s.equals("errFile")) {
		    errFile = a[++i];
		    continue;
		} else if (s.equals("nonzero")) {
		    nonZero = true;
		    continue;
		} else if (s.equals("zero")) {
		    nonZero = false;
		    continue;
		} else if (s.equals("cmd")) {
		    cmd = new String[a.length - (++i)];
		    System.arraycopy(a, i, cmd, 0, a.length - i);
		    return;
		} else if (s.equals("random")) {
		    random = true;
		    continue;
		} else if (s.equals("execFailure")) {
		    execFailure = true;
		    continue;
		} else if (s.equals("seed")) {
		    seed = Integer.parseInt(a[++i]);
		    continue;
		} else if (s.equals("exception")) {
		    exceptionOnFirstExit = true;
		    continue;
		} else {
		    System.err.println("Unrecognized argument: " + s);
		    usage();
		    System.exit(1);
		}
	    }
	} catch (Exception e) {
	    usage();
	    fail(e);
	}
	if ((cmd == null || cmd.length == 0) && !random) {
	    usage();
	    System.exit(1);
	}
	if (!random && (errFile == null || outFile == null)) {
	    usage();
	    System.exit(1);
	}
    }

    void usage() {
	System.out.println("java ProcTest [stuff]");
    }

    boolean wait = false; /* wait for exit before reading? */
    boolean random = false; /* random output */
    int seed = 0; // seed for random numbers
    static boolean verbose = false;
    String errFile; /* filename that contains expected stdout */
    String outFile; /* filename that contains expected stderr */
    String inFile; /* filename that should be fed to stdin */
    String[] cmd = null; /* process to be exec'd */
    /* should get IllegalThreadStateException if calling Process.exitValue()
     * before it exited.
     */
    boolean execFailure = false; // expect failure on exec?
    boolean exceptionOnFirstExit = false; 
    boolean nonZero; /* expected exit value */


    public void run() {
	try {
	    if (random) {
		doRand();
		return;
	    }
	    int returnVal;
	    Process p=null;
	    try {
		p = Runtime.getRuntime().exec(cmd);
	    } catch (Exception e) {
		if (execFailure) {
		    verbose("correct exception on " + cmd[0]);
		    System.exit(0);
		} else {
		    throw e;
		}
	    }
	    if (exceptionOnFirstExit) {
		try {
		    p.exitValue();
		    fail(new RuntimeException("expected IllegalThreadStateException from Process.exitValue()"));
		} catch (IllegalThreadStateException correct){}
	    }

	    Thread t1 = new Thread(new Reader(outFile, p.getInputStream()), "stdout reader for " + cmd[0]);
	    t1.start();

	    if (inFile != null) {
		InputStream is = new BufferedInputStream(new FileInputStream(inFile));
		byte[] b = new byte[1024];
		int n;
		int count = 0;
		OutputStream os = p.getOutputStream();
		while ((n = is.read(b)) != -1) {
		    count += n;
		    verbose("ProcTest:writeToProcess: count = " + count);
		    os.write(b, 0, n);
		    verbose("ProcTest:writeToProcess wrote count=" + count);
		    os.flush();
		}
		is.close();
		verbose("ProcTest:writeToProcess: done, closing stdin:");
		os.close();
		verbose("ProcTest:writeToProcess: closed stdin OK...");
	    }
	    if (wait) {
		verbose("wait for process to exit:");
		returnVal = p.waitFor();
		verbose("Process exited!");
		if (nonZero) {
		    assert(returnVal != 0, "Wrong return value: got="+returnVal+
			   ", expected non-zero");
		} else {
		    assert(returnVal == 0, "Wrong return value: got="+returnVal+
			   ", expected zero");
		}
	    }

	    Thread t2 = new Thread(new Reader(errFile, p.getErrorStream()), "stderr reader for " + cmd[0]);

	    t2.start();
	    t1.join();
	    t2.join();
	    
	    returnVal = p.waitFor();
	    if (nonZero) {
		assert(returnVal != 0, "Wrong return value: got="+returnVal+
		       ", expected non-zero");
	    } else {
		assert(returnVal == 0, "Wrong return value: got="+returnVal+
		       ", expected zero");
	    }
	    assert(p.waitFor() == p.exitValue(), "p.exitValue() != p.waitFor()");
	    verbose("test exec for " + cmd[0] + " passed.");
	} catch (Exception e) {
	    fail(e);
	}
    }

    void doRand() {}
}
	    
class Reader extends ProcTest {

    InputStream p;
    InputStream exp;
    static final int SZ = 512;
    byte[] b1 = new byte[SZ];
    byte[] b2 = new byte[SZ];

    Reader(String file, InputStream proc) throws IOException {
	exp = new BufferedInputStream(new FileInputStream(file));
	if (!proc.markSupported())
	    p = new BufferedInputStream(proc);
	else 
	    p = proc;
    }


    public void run() {

	int r1, r2, n=0;

	try {
	    while (true) {
		p.mark(SZ);
		//		p("read process:");
		r1 = p.read(b1);

		exp.mark(SZ);
		//		p("read expected:");
		r2 = exp.read(b2);
		if (r1 == -1 && r2 == -1) {
		    return;
		} else if (r1 == -1 && r2 != -1) {
		    throw new Exception("output differs from expected, " + (n+r1) +", " + (n+r2));
		} else if (r1 < r2) {
		    exp.reset();
		    exp.skip((long)(r1));
		    r2 = r1;
		} else if (r2 < r1) {
		    p.reset();
		    p.skip((long)r2);
		    r1 = r2;
		}
	    
		comp(r1, n);
		n += r1;
	    }
	} catch (Exception e) {
	    fail(e);
	}
    } 

    void comp(int len, int total) throws Exception {
	for (int i = 0; i < len; i++) 
	    if (b1[i] != b2[i]) 
		throw new Exception("outputs differ at position "+(total+i)+", " +
				    (char)b1[i] + "/" + (char)b2[i]);
    }
}

