#!/bin/sh
#
# Test Runtime.exec()
# assumes that you have the java runtime to be tested in your path
# and that you have a Bourne shell interpreter (for win32).

rm -rf .fail.list


if [ ! -f ProcTest.class ] || [ ! -f Reader.class ] ; then
  echo compiling ProcTest.java:
  if javac ProcTest.java  ; then
    true;
  else
    echo "compilation failed"; 
    exit 1;
  fi
fi



case `uname` in
	"SunOS") \
	set 'who' 'whoami' \
	'sh envTest.sh' '/home/brown/bin/retTest' 'ls /usr/include'\
	'cat /home/brown/ps/rfc/long.html' \
	'ping cafedead' 'cc' 'uname -a';;

	Win*) \
	set 'cat ProcTest.java' 'cc' 'sh envTest.sh' 'ls C:' 'cl' 'uname -a';;

	*) echo unrecognized OS $OS_NAME; exit 1;;
esac

echo run platform tests for `uname`;

FOO=BAR;
export FOO;

for i do
echo $i;
if $i > tmp.out 2> tmp.err; then
  zero=zero;
else
  zero=nonzero;
fi

# exec and don't wait to read output
if java ProcTest outFile tmp.out errFile tmp.err $zero cmd $i ; then
  echo "OK";
else
  echo "FAILED!";
  echo java procTest outFile tmp.out errFile tmp.err $zero cmd $i >> .fail.list;
fi

# exec and wait to read output
if java ProcTest wait outFile tmp.out errFile tmp.err $zero cmd $i ; then
  echo "OK";
else
  echo "FAILED!";
  echo java procTest wait outFile tmp.out errFile tmp.err $zero cmd $i >> .fail.list;
fi
done

# should get correct Exception trying to exec a non-existent command

echo "get correct error executing non-existent program:"

if java ProcTest outFile tmp.out errFile tmp.err execFailure cmd doesNotExist.exe ; then
  echo "OK";
else
  echo "FAILED!";
  echo java ProcTest outFile tmp.out errFile tmp.err execFailure cmd doesNotExist.exe >> .fail.list
fi

case `uname` in
  "SunOS") echo "try to exec non-executable UNIX file:";
   if java ProcTest outFile /dev/null errFile /dev/null execFailure cmd /etc/passwd ; then
     echo "OK";
  else
    echo "FAILED!";
    echo java ProcTest outFile /dev/null errFile /dev/null execFailure cmd /etc/passwd >> .fail.list
  fi;;
  *);;
esac
	

# test writing to stdin of a process

rm tmp.err;
rm tmp.out;
touch tmp.err;

echo "write to stdin of child:";

case `uname` in
  Win*) echo currently hangs on win32...;;
  *);;
esac

if java ProcTest inFile ProcTest.java outFile ProcTest.java errFile tmp.err \
	exception cmd cat -u; then
  echo OK;
else
  echo "FAILED!";
  echo java ProcTest inFile ProcTest.java outFile ProcTest.java errFile tmp.err \
	exception cmd cat >> .fail.list 
fi

rm tmp.err;

echo DONE!

if [ -f .fail.list ] ; then 
  STATUS=1;
  echo FAILED exec tests: 
  cat .fail.list;
  rm .fail.list;
else
  STATUS=0;
  echo PASSED all exec tests.
fi

exit $STATUS
