/*
 * @(#)ClientBindTest.java	1.3 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.net.*;
import java.io.*;

/* tests:
   1) binding to local addr, port for socket
   2) SoTimeout
   expects to connect to an echo server to succeed
   */
class ClientBindTest extends NetTest {

    public static void main(String argv[]) {
      (new ClientBindTest(argv)).run();
    }

    public ClientBindTest(String[] argv) {
	super(argv);
    }

    protected void usage() {
	p("java ClientBindTest [local-addr local-port] [verbose]");
	p("tests binding client Socket to local address/port.  If none specified a default is used.");
	exit();
    }

    public void run() {
	InetAddress local;
	int localport;
	byte[] msg = {
	    'H', 'e', 'l', 'l', 'o', '\r', '\n'
	};

	String remote;
	int rport;
	
	try {
	    if(argv.length < 2) {
		local = InetAddress.getLocalHost();
		localport = (new java.util.Random(System.currentTimeMillis())).nextInt();
		localport = Math.abs(localport);
		localport = (localport % 0x7FFF) + 0x8000; // get it btw. 0x8000 and 0xFFFF
		p("localport: " + localport);
	    } else {
		local = InetAddress.getByName(argv[0]);
		localport = Integer.parseInt(argv[1]);
	    }

	    if (argv.length > 2) {
		remote = argv[2];
		rport = Integer.parseInt(argv[3]);
	    } else {
		remote = "monkey.eng.sun.com";
		rport = 7;
	    }
	    InetAddress raddr = InetAddress.getByName(remote);
	    verbose("make socket to "+remote+"/"+rport + ", local-addr " +
	      local + "/" + localport + ":");
	    Socket s = new Socket(raddr, rport, local, localport);
	    
	    verbose("Made socket w/ local address " + s.getLocalAddress() + ", set timeout 5000 ms:");
	    if(!local.equals(s.getLocalAddress())) {
		pe("requested local address " + local + " != " +s.getLocalAddress());
	    }
	    if (!raddr.equals(s.getInetAddress())) {
		pe("requested remote address " + raddr + " != " +s.getInetAddress());
	    }
	    if (s.getPort() != rport) {
		pe("requested remote port " + rport + " != " +s.getPort());
	    }
	    if (s.getLocalPort() != localport) {
		pe("requested local port " + localport + " != " +s.getLocalPort());
	    }
	    s.setSoTimeout(5000);
	    verbose("timeout set to " + s.getSoTimeout());
	    s.getOutputStream().write(msg);
	    InputStream is = s.getInputStream();
	    int r, nread = 0;
	    while((r = is.read()) > 0 && ++nread < msg.length) {
		System.out.write((char)r);
	    }
	    System.out.flush();
	    // try binding to same local port - expect BindException

	/*    verbose ("try making identical socket:");
	    try {
		Socket s2 = new Socket(raddr, rport, local, localport);
		verbose("didn't get expected bind exception 1");
		verbose("first socket: " + s);
		verbose("2nd socket: " + s2);
		pe("Didn't get expected bindException 1");
	    } catch (BindException e) {
		verbose ("Got expected exception " + e);
	    }
	*/
	    // try binding to bogus local address
	    try {
		Socket s2 = new Socket(raddr, rport, 
			    InetAddress.getByName("128.59.25.2"), localport);
		verbose("didn't get expected bind exception 2");
		pe("Didn't get expected bindException 2");
	    } catch (BindException e) {
		verbose ("Got expected exception " + e);
	    }
	    verbose("still have first socket: " + s);
	    verbose("Done w/ test");
	} catch (InterruptedIOException e) {
	    pe("read timedout, echo server not responding");
	} catch(Exception e) {
	    pe(e);
	}
	exit();
    }
}
