/*
 * @(#)IANumberTest.java	1.4 97/08/09
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
// check parsing + security of numerical IP addresses
import java.net.*;
import java.io.*;
import java.applet.*;
import java.awt.*;
public class IANumberTest extends NetTest {

    static final String[] good = {
	"129.144.175.147", "129.144.175.42", "244.88.77.45",
	"128.59.25.2", "1.1.1.1", "255.255.255.255", 
	"224.0.0.1", "239.255.255.255", "0.0.0.255", "127.0.0.1",
	"129.144.175.255", "4.5.6.7",
	"122.218.5.39", "78.38.217.58", "101.86.29.60", "7.7.109.168", 
	"117.48.225.212", "182.142.100.86", "189.212.95.129", "75.38.224.69", 
	"86.214.200.0", "98.213.17.171", "134.214.214.246", "153.152.51.154", 
	"63.77.124.151", "65.153.7.147", "5.41.7.27", "113.67.150.239", 
	"46.97.150.36", "122.62.95.57", "137.84.250.250", "183.66.224.78", 
	"95.18.236.172", "197.208.132.124", "212.129.168.13", "20.202.233.99", 
	"173.107.236.145", "213.229.145.207", "113.91.79.20", "86.8.231.96", 
	"238.107.253.111", "174.121.178.26", "27.232.214.0", "210.253.214.214", 
	"89.220.226.254", "12.205.135.148", "25.114.50.199", "195.103.207.161", 
	"221.61.21.242", "189.77.127.173", "158.96.186.83", "167.151.114.184", 
	"140.151.41.217", "12.107.61.228", "48.26.151.81", "164.87.58.29", 
	"242.101.45.253", "16.129.242.174", "253.227.23.31", "227.199.232.176", 
	"124.114.7.71", "29.176.197.84", "67.197.15.163", "245.67.223.24", 
	"208.183.216.22", "24.192.42.208", "173.101.67.51", "48.56.128.156", 
	"53.62.92.38", "222.2.74.177", "179.230.189.108", "13.17.143.11", 
	"236.254.69.114", "161.45.93.249", "252.206.51.24", "141.12.148.147", 
	"154.195.161.13", "71.65.15.1", "187.224.97.14", "151.31.52.170", 
	"153.2.54.6", "205.100.218.77", "18.2.111.14", "86.217.153.229", 
	"104.195.228.72", "166.196.110.126", "109.21.79.164", "153.66.205.224", 
	"254.124.6.122", "26.120.9.35", "234.219.26.11", "58.180.29.25", 
	"52.244.205.222", "164.92.218.159", "178.215.116.5", "113.199.116.208", 
	"28.35.169.51", "88.245.102.12", "93.44.236.193", "67.38.195.235", 
	"104.10.157.142", "63.79.222.18", "78.120.88.186", "211.117.89.212", 
	"200.160.171.71", "180.222.138.208", "24.190.57.151", "209.47.73.86", 
	"74.170.44.205", "205.93.30.185", "218.62.23.10", "205.136.197.128", 
	"182.155.48.139", "177.174.34.114", "161.85.231.174", "160.73.131.135", 
	"245.118.230.200", "0.189.81.180", "200.101.103.237", "197.181.25.159", 
	"109.174.243.136", "43.90.245.43", "88.171.124.220", "191.102.94.228", 
	"96.7.214.103", "219.31.77.86", "100.38.150.27", "118.44.204.52", 
	"77.112.73.127", "83.76.228.106", "112.114.16.179", "152.238.223.14", 
	"83.235.156.70", "194.170.250.45", "206.174.138.252", "246.144.113.120", 
	"142.107.28.108", "181.104.226.216", "250.85.83.122", "235.197.34.218", 
	"117.173.110.188", "106.253.94.252", "1.37.192.183", "180.254.176.224", 
	"64.36.240.254", "53.9.2.89", "219.246.145.48", "211.67.92.89", 
	"66.205.28.214", "225.49.145.194", "207.167.78.40", "115.15.73.23", 
	"76.24.225.162", "14.3.102.3", "209.240.170.142", "192.56.217.207", 
	"13.194.14.92", "144.211.199.180", "227.76.225.224", "80.204.21.254", 
	"113.187.164.120", "210.161.80.39", "115.212.25.5", "124.239.0.190", 
	"3.254.67.201", "54.237.75.62", "190.35.192.46", "194.189.4.178", 
	"73.122.131.91", "111.166.21.79", "47.47.239.186", "39.42.75.220", 
	"40.233.84.86", "232.253.126.5", "187.49.200.21", "149.223.32.133", 
	"67.184.98.220", "37.79.37.60", "74.129.214.144", "59.34.79.24", 
	"88.227.112.238", "25.251.219.229", "13.118.110.79", "238.168.136.2", 
	"166.211.188.70", "144.78.6.230", "227.70.16.30", "137.135.186.151", 
	"72.69.95.57", "141.87.246.245", "188.230.193.83", "76.5.119.236", 
	"148.32.167.154", "165.207.85.127", "241.238.117.178", "59.132.81.186", 
	"131.95.128.148", "100.246.121.129", "171.115.102.75", "129.91.60.62", 
	"6.233.204.146", "173.118.204.111", "66.231.120.87", "208.185.238.24", 
	"109.121.202.22", "23.59.40.15", "150.1.154.28", "189.135.64.43", 
	"201.117.113.160", "77.93.56.88", "122.145.36.202", "36.66.137.127"

    };

    static final String[] bad = {
	"4.5.6.Z", "2.4.5.7.g", "2.3.4.5.6", "3.A.4.5", "5.7.8..9", "4.9.-9.3",
	"3.3@.4.4", "6.y.3.4"
    };

    public static void main(String[] a) {
      (new IANumberTest(a)).run();
    }
    
    public IANumberTest(String[] a) {
	super(a);
    }

    protected void usage() {
	p("java IANumberTest [verbose]\ntests parsing IP address strings.");
	exit();
    }

    public void run() {
	InetAddress in = null;
	p("test good addresses:");
	for (int i = 0; i < good.length; i++) {
	    try {
		in = InetAddress.getByName(good[i]);
		if (verbose) {
		  verbose("Got good: " + in);
		  assert(in.getHostAddress().equals(good[i]), 
			 in.getHostAddress()+" != " + good[i]);
		}
	    } catch (IOException e) {
		pe(e);
	    }
	    System.out.write('.');
	    System.out.flush();
	}
	System.out.println();
	p("test bad addresses: (takes awhile to timeout...) ");
	for (int i = 0; i < bad.length; i++) {
	    try {
		in = InetAddress.getByName(bad[i]);
		pe("Unexpected success: " + in);
	    } catch (UnknownHostException e) {
		verbose("got expected exception: " + e);
	    } catch (IOException e) {
		pe(e);
	    }
	    System.out.write('.');
	    System.out.flush();
	}
	System.out.println();
	p("Get local address:");
	try {
	    in = InetAddress.getLocalHost();
	    verbose("got localhost " + in);
	} catch (IOException e) {
	    pe("got unexpected exception on localhost: " + e);
	}
	/* test hostnames that start with a digit */
	try {
	    in = InetAddress.getByName("1host.dvv.ru");
	    String addr = in.getHostAddress();
	    assert("194.87.14.55".equals(addr), "expected 1host.dvv.ru->194.87.14.55, got: " + addr);
	} catch (IOException e) {
	    pe(e);
	}
	exit();
    }

   public void paint(Graphics g) {
        g.setColor(Color.red);
        g.drawString("Running Inet Tests", 5, 25);
	run();
        g.drawString("Done with Inet Tests", 5, 50);
   }
}
	

