import java.io.*;
import java.net.*;

public class MulticastTest extends NetTest {
    
    int clientPort=9045;
    int serverPort=4590;
    InetAddress client_maddr;
    InetAddress server_maddr;
    InetAddress interFace;
    static int numClients = 3;
    static byte[] msg = new byte[10];

    static {
	for (int i = 0; i < msg.length; i++) 
	    msg[i] = (byte)i;
    }

    protected void usage() {
	p("java " + this.getClass().getName() +": [mcast-addr] [port] <interface-addr> " +
	  "[\"clients\" <num-clients>] <verbose>");
	p("  mcast-addr: multicast group (defaults: 225.9.9.9/client, 234.6.6.6/server)");
	p("  port: the port (default: 9045/client, 4590/server)");
	p("  interface: the local interface to send mcasts out onto (default: local address)");
	p("  clients: #clients subscribing to a mcast server <default to 3>");
	exit();
    }

    public static void main(String[] a) {
	for (int i = 0; i < a.length; i++)
	    if (a[i].equals("clients"))
		numClients = Integer.parseInt(a[++i]);

	new MulticastTest(a).run();
    }

    public MulticastTest(String[] a) {
	super(a);
	try {
	    client_maddr = InetAddress.getByName("225.9.9.9");
	    server_maddr = InetAddress.getByName("234.6.6.6");
	    interFace = InetAddress.getLocalHost();
	} catch (Exception e) {
	    pe(e);
	    exit();
	}
    }

    public void run() {
	

	for (int i = 0; i < numClients; i++) {
	    MulticastClient c = new MulticastClient(argv);
	    (new Thread(c, "mcast-client #"+i)).start();
	}

	try {
	    Thread.sleep(3000);
	} catch (Exception e){
	    pe(e);
	}
	MulticastServer serv = new MulticastServer(argv);
	(new Thread(serv, "mcast-server")).start();
	exit();
    }
}

class MulticastServer extends MulticastTest {

    MulticastServer(String[] a) {
	super(a);
    }

    public void run() {
	try {
	    MulticastSocket s = new MulticastSocket(serverPort);
	    assert(s.getLocalPort() == serverPort, "socket port not correct");
	    verbose("made socket: local if is " + s.getInterface());
	    s.setInterface(interFace);

	    assert(interFace.equals(s.getInterface()), "socket interface not set correctly");
	    verbose("Interface set to " + s.getInterface());

	    s.joinGroup(server_maddr);
	    verbose("joined group/port: " + server_maddr.getHostAddress() 
		    +"/" + serverPort);

	    byte ttl = 0x0E;

	    assert(s.getTTL() == 0x01, "initial TTL != 1: instead " + s.getTTL());
	    s.setTTL(ttl);
	    assert(s.getTTL() == ttl, "ttl: " + ttl + " != " + s.getTTL());

	    // send broadcast to clients
	    
	    DatagramPacket send = new DatagramPacket(msg, msg.length, client_maddr, clientPort);
	    byte[] buf = new byte[1000];
	    DatagramPacket recv = new DatagramPacket(buf, buf.length);
	    verbose("mcast to clients:");

	    // this shouldn't change default ttl
	    s.send(send, (byte)0x0A);

	    assert(s.getTTL() == ttl, ttl + " != " + s.getTTL());
	    
	    int livingClients = numClients;
	    
	    s.setSoTimeout(5000);
	    
	    assert (s.getSoTimeout() == 5000, "wrong timeout");

	    try {
		while (livingClients > 0) {
		    verbose("receive reply #"+livingClients);
		    s.receive(recv);
		    assert(recv.getPort() == clientPort, "ports not equal");
		    assert(recv.getLength() == msg.length, "received length != expected length");
		    for (int i = 0; i < msg.length; i++) 
			assert(msg[i] == buf[i], "bytes differ at " + i);
		    livingClients--;
		}
		verbose("received all replies!");
	    } catch (InterruptedIOException e) {
		// retry - clients may have missed first one
		s.send(send);
		retry(s, livingClients);
		verbose("received all replies!");
	    }
	    s.close();

	    verbose("closed socket: try re-setting options (expect exception):");
	    try {
		s.setInterface(interFace);
		pe("Error! set interface OK on closed socket!");
		exit();
	    } catch (IOException correct) {}
	} catch (Exception e) {
	    pe(e);
	}
	exit();
    }

    void retry (DatagramSocket s, int toGo) throws IOException {
	byte[] buf = new byte[100];
	DatagramPacket recv = new DatagramPacket(buf, buf.length);
	while (toGo > 0) {
	    verbose("receive reply #"+toGo);
	    s.receive(recv);
	    assert(recv.getPort() == clientPort, "ports not equal");
	    assert(recv.getLength() == msg.length, "received length != expected length");
	    for (int i = 0; i < msg.length; i++) 
		assert(msg[i] == buf[i], "bytes differ at " + i);
	    toGo--;
	}
    }
}	    

class MulticastClient extends MulticastTest {

    MulticastClient(String[] a) {
	super(a);
    }

    public void run() {
	
	try {
	    MulticastSocket s = new MulticastSocket(clientPort);
	    assert(s.getLocalPort() == clientPort, "socket port not correct");
	    verbose("made socket: local if is " + s.getInterface());
	    s.setInterface(interFace);

	    assert(interFace.equals(s.getInterface()), "socket interface not set correctly");
	    verbose("Interface set to " + s.getInterface());

	    s.joinGroup(client_maddr);
	    verbose("joined group/port: " + client_maddr.getHostAddress() +"/" + clientPort);

	    byte[] buf = new byte[1000];
	    DatagramPacket dp = new DatagramPacket(buf, buf.length);

	    verbose("receive from sender:");
	    s.receive(dp);
	    verbose("mcast-client: received something back");
	    assert(dp.getPort() == serverPort, "ports not equal");
	    assert(dp.getLength() == msg.length, "received length != msg.length");

	    DatagramPacket dp2 = new DatagramPacket(msg, msg.length, server_maddr, serverPort);

	    byte ttl = 0x0E;

	    assert(s.getTTL() == 0x01, "initial TTL != 1: instead " + s.getTTL());
	    s.setTTL(ttl);
	    assert(s.getTTL() == ttl, "ttl: " + ttl + " != " + s.getTTL());
	    s.send(dp2);
	    s.close();

	    verbose("m-cast client: closed socket: try re-setting options (expect exception):");
	    try {
		s.setInterface(interFace);
		pe("Error! set interface OK on closed socket!");
	    } catch (IOException correct) {}
	} catch (Exception e) {
	    pe(e);
	}
	exit();
    }
}



