/*
 * @(#)NetTest.java	1.5 97/01/27
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.net.*; 
import java.io.*; 
 
public class NetTest implements Runnable { 
 
    /* cmd - line args */ 
    protected String[] argv; 
    /* num errors */ 
    protected int numErrors; 
    /* log errors to */ 
    protected PrintStream errLog; 
    /* number of tests running */ 
    protected static int numTests = 0; 
    /* total errors in this runtime, across all threads */ 
    protected static int totalErrors =0; 
    /* cumulative test count */
    protected static int totalTests = 0;
    /* sleep time btw. starting client threads, ms */
    private int sleep = 1000;
    /* static verbose boolean */
    private static boolean verbose_static = false;
    /* verbose output? */ 
    protected boolean verbose = false; 
    private static Class thisClass; 

    /* initialize log */
    void makeErr() {
	if (errLog == null) {
	    try { 
		errLog = new PrintStream(new FileOutputStream(getClass().getName() + ".log", true)); 
	    } catch (Exception e) { 
		e.printStackTrace(); 
		System.exit(1);
	    } 
	}
    }
 
    static { 
	try { 
	    thisClass = Class.forName("NetTest"); 
	} catch (Exception e) { 
	    e.printStackTrace();
	    System.exit(1); 
	} 
    } 
 
    public static void p(String s) { 
	System.out.println(Thread.currentThread().getName()+"> " +s); 
    } 
 
    public void verbose(String s) { 
	if (verbose) 
	    p(s); 
    } 
 
    public void pe(String s) { 
	makeErr();
	String name = Thread.currentThread().getName();
	System.err.println("thread="+name + ": " + ++numErrors + ") " + s); 
	errLog.println("thread="+name + ": " + numErrors + ") " + s); 
	totalErrors++; 
    } 
 
    public void pe(Exception e) { 
	makeErr();
	numErrors++; 
	totalErrors++; 
	String name = Thread.currentThread().getName();
	PrintStream tmp = System.err; 
        tmp.print("thread="+name + ": " + numErrors + ") "); 
	e.printStackTrace(); 
 
	System.setErr(errLog); 
  
        errLog.print("thread="+name +": " + numErrors + ") "); 
	e.printStackTrace(); 
	System.setErr(tmp); 
    } 
     
    /* subclasses should override */
    protected void usage() {
	p("NetTest: java NetTest [vebose] <argv> runs in order:\n\tjava SocketTimedTest <argv> " + 
	  "\n\tjava IANumberTest <argv>" + "\n\tjava ClientBindTest <argv>" + "\n\tjava UDPBindTest <argv>"+
	  "\n\tjava TcpNoDelayTest <argv>" + "\n\tjava UDPTimedTest <argv>" + 
	  "\n\"verbose\": verbose output" + 
	  "\n\"usage\" on an individual subclass prints its particular usage.");
	exit();
    }
    public void assert(boolean mustBeTrue, String ex) { 
	try { 
	    if (!mustBeTrue) 
		throw new Exception(ex); 
	} catch (Exception e) { 
	    pe(e); 
	} 
    } 
 
    public final void exit() { 
	synchronized (thisClass) { 
	    numTests--; 
	    try {
		// flush log file if any errors
		if (errLog != null) {
		    errLog.flush();
		    errLog.close();
		}
		    
	    } catch (Exception e) { 
		pe(e); 
	    } 
	    String name = Thread.currentThread().getName();
	    if (numErrors == 0) { 
		p(getClass().getName() + "/"+name + " passed."); 
	    } else { 
		System.err.println("Test for " + getClass().getName()+"/"+name
				   + " failed w/ " + numErrors + " errors."); 
		System.err.println("Review error log file " + getClass().getName() 
				   + ".log for details."); 
	    } 
	    if (numTests <= 0) { 
		p("Process exiting w/ " + totalErrors + " total errors in "+totalTests + " total tests run."); 
		System.exit(totalErrors); 
	    } else { 
		p(getClass().getName() + " test exiting, " + numTests + " tests still to go."); 
	    } 
	} 
    } 
 
    public NetTest(String[] a) { 
	synchronized (thisClass) { 
	    argv = a; 
	    numErrors = 0; 
	    numTests++; 
	    totalTests++;
	} 
	if (argv != null) { 
	    for (int i = 0; i < argv.length; i++) { 
		if("verbose".equals(argv[i])) { 
		    verbose = true;
		    verbose_static = true;
		    argv[i] = ""; 
		    String[] tmp = new String[argv.length - 1]; 
		    for (int j = 0; j < i; j++) { 
			tmp[j] = argv[j]; 
		    } 
		    for (int j = i+1; j < argv.length; j++) { 
			tmp[j-1] = argv[j]; 
		    } 
		    argv = tmp; 
		} else if (argv[i].equals("usage")) {
		    usage();
		    exit();
		}
	    } 
	} 
	verbose = verbose_static;
    }
 
    private NetTest(String[] a, boolean ignore) { 
	this(a); 
    } 
 
    public void run() { 
	try { 
	    p("start net tests:");
	    p("start SocketTimedTest:"); 
	    (new Thread(new SocketTimedTest(argv), "SocketTimedTest")).start(); 
 
	    /*
	    p("start IANumberTest:"); 
	    (new Thread(new IANumberTest(argv), "IANumberTest")).start(); 
	    */
 

	    p("start ClientBindTest:"); 
	    (new Thread(new ClientBindTest(argv), "ClientBindTest")).start(); 

	    p("start TCPCloseTest:"); 
	    (new Thread(new TCPCloseTest(argv), "TCPCloseTest")).start(); 

	    p("start UDPCloseTest:"); 
	    (new Thread(new UDPCloseTest(argv), "UDPCloseTest")).start(); 
      
	    p("start TcpNoDelayTest:"); 
	    (new Thread(new TcpNoDelayTest(argv), "TcpNoDelayTest")).start(); 
 
	    p("start UDPBindTest:"); 
	    (new Thread(new UDPBindTest(argv), "UDPBindTest")).start(); 
      
	    p("start UDPTimedTest:"); 
	    (new Thread(new UDPTimedTest(argv), "UDPTimedTest")).start(); 

	    p("start MulticastTest:");
	    (new Thread(new MulticastTest(argv), "MulticastTest")).start();

	    p("start NullPtrTest:");
	    (new Thread(new NullPtrTest(argv), "NullPtrTest")).start();

	    p("started all tests"); 
	} catch (Exception e) { 
	    pe(e); 
	} 
	exit(); 
    } 
    public static void main(String argv[]) throws Exception { 
	(new Thread(new NetTest(argv, true), "NetTestMain")).start(); 
    } 
} 
     
      
  
