import java.net.*;
import java.io.*;

/* pass null pointers to native code in every conceivable
 * way to see if all null checking is done correctly
 *
 * The basic premise of this test is that if the runtime
 * doesn't crash it passed.
 */

public class NullPtrTest extends NetTest {
    
    NullPtrTest(String[] a) {
	super(a);
    }

    public static void main(String[] a) {
	new NullPtrTest(a).run();
    }

    public void run() {
	Socket s;
	DatagramSocket dg;
	ServerSocket ss;
	InputStream is = null;
	OutputStream os = null;
	MulticastSocket m = null;
	try {
	    InetAddress a = InetAddress.getByName("monkey.eng.sun.com");
	    s = new Socket(a, 7);
	    os = s.getOutputStream();
	    is = s.getInputStream();
	    os.write('X');
	    verbose("Socket, null read:");
	    try {
		is.read(null, 0, 10);
		pe("xpected null ptr");
	    } catch (NullPointerException OK) {}
	    verbose("Socket, null write:");
	    try {
		os.write(null, 0, 10);
		pe("xpected null ptr");
	    } catch (NullPointerException OK) {}
	    s.close();
	    s.close();
	    s.close();
	    
	    dg = new DatagramSocket();
	    DatagramPacket p = null;
	    byte[] buf = new byte[10];

	    verbose("DG, null packet:");
	    try {
		// null packet
		dg.send(p);
		pe("xpected null ptr");
	    } catch (NullPointerException OK) {}
	    verbose("DG, null buffer:");
	    try {
		// null buffer
		p = new DatagramPacket(null, 10, a, 7);
		dg.send(p);
		pe("xpected null ptr");
	    } catch (NullPointerException OK) {}
	    verbose("DG, null address:");
	    try {
		// null address
		p = new DatagramPacket(buf, 10, null, 7);
		dg.send(p);
		pe("xpected null ptr");
	    } catch (NullPointerException OK) {}
	    verbose("DG, illegal array len:");
	    try {
		// exceed array index (by lots!)
		p = new DatagramPacket(buf, 3000, a, 7);
		dg.send(p);
		pe("xpected array index exception");
	    } catch (RuntimeException OK) {}
	    
	    p = new DatagramPacket(buf, 10, a, 7);
	    dg.send(p);

	    verbose("DG, null packet receive:");
	    
	    try {
		// receive into null packet
		dg.receive(null);
		pe("xpected null ptr");
	    } catch (NullPointerException OK) {}
	    
	    
	    try {
		// receive into null buffer
		p = new DatagramPacket(null, 10);
		dg.receive(p);
		pe("xpected null ptr");
	    } catch (NullPointerException OK) {}

	    dg.close();
	    dg.close();
	    dg.close();

	    p = new DatagramPacket(buf, 10, a, 7);
	    
	    try {
		// receive after closed 
		dg.receive(p);
	    } catch (Exception OK) {}

	    try {
		// receive after closed 
		dg.send(p);
	    } catch (Exception OK) {}

	    
	    m = new MulticastSocket(9090);

	    verbose("Made mcast socket.  join null group:");
	    
	    try {
		// join null group
		m.joinGroup(null);
		pe("xpected null ptr");
	    } catch (NullPointerException OK) {}

	    verbose("mcast socket, leave null group:");

	    try {
		// leave null group
		m.leaveGroup(null);
		pe("xpected null ptr");
	    } catch (NullPointerException OK) {}

	    verbose("mcast socket, send null packet:");

	    try {
		m.send(null, (byte)4);
		pe("xpected null ptr");
	    } catch (NullPointerException OK) {}

	    m.close();
	    m.close();
	    m.close();

	    p = new DatagramPacket(buf, 10, a, 7);
	    
	    try {
		// receive after closed 
		m.receive(p);
	    } catch (Exception OK) {}

	    try {
		// receive after closed 
		m.send(p);
	    } catch (Exception OK) {}
	    
	    ss = new ServerSocket(5757, 5757, null);
	    
	    ss.close();
	    ss.close();
	    ss.close();
	    
	    s.close();
	    Thread.sleep(500);
	    dg.close();
	    Thread.sleep(500);
	    m.close();
	    Thread.sleep(500);
	    ss.close();
	} catch (Exception e) {
	    pe(e);
	}
	exit();
    }
}
		
