import java.net.*;
import java.io.*;

/* A test to see that one thread can close a ServerSocket
 * while another thread is in accept(), and that the right
 * thing happens.
 * Also check that the right thing happens when a client
 * Socket is closed.
 */
public class TCPCloseTest extends NetTest {

    public static void main (String[] a) {
	(new TCPCloseTest(a)).run();
    }

    TCPCloseTest(String[] a) {
	super(a);
    }

    public void run() {
	try {
	    ServerSocket s = new ServerSocket(0);

	    p("port="+s.getLocalPort()+", Start thread to do recvfrom: ");

	    Accept a = new Accept(argv, s);
	    a.verbose = this.verbose;
	    (new Thread(a, "TCP accept thread")).start();
	    Thread.sleep(3000); // relinquish CPU for green threads....
	    verbose("try to close serversocket:");
	    s.close();
	    s = new ServerSocket(0);
	    Socket s1 = new Socket(InetAddress.getLocalHost(), s.getLocalPort());
	    TCPRead r = new TCPRead(argv, s1);
	    r.verbose = this.verbose;
	    (new Thread(r, "TCP reader thread")).start();
	    Thread.sleep(3000);
	    verbose("try to close client socket:");
	    s1.close();
	    verbose("did close, exiting....");
	} catch (Exception e) {
	    pe(e);
	}
	exit();
    }
}

class TCPRead extends NetTest {
    Socket s;
    TCPRead(String[] a, Socket s) {
	super(a);
	this.s = s;
    }

    public void run() {
	long start = System.currentTimeMillis();
	try {
	    verbose("Running read thread");
	    s.setSoTimeout(30000);
	    p("soTimeout is " + s.getSoTimeout() + " do read:");
	    s.getInputStream().read();
	    p("Unexpected (but not error), read some bytes");
	    System.exit(0);
	} catch (InterruptedIOException e) {
	    pe("shouldn't have timed out!");
	} catch (IOException e) {
	    long delta = System.currentTimeMillis() - start;
	    /* this is a bit hokey - look for "losed" in the xception string
	     * to see if we got the right exception
	     */
	    assert(e.getMessage().indexOf("losed") > 0, "wrong exception after close " +
		   e.getMessage());

	    assert(delta < 10000, "awakening from close took too long: " + delta);
	    verbose("correct exception? " + e);
	} catch (Exception e) {
	    pe(e);
	    e.printStackTrace();
	}
	exit();
    }	    
}

class Accept extends NetTest {

    ServerSocket s;

    Accept (String[] a, ServerSocket s) {
	super(a);
	this.s = s;
    }

    public void run() {
	verbose("Running accept thread");
	long start = System.currentTimeMillis();
	try {
	    s.setSoTimeout(30000);
	    p("soTimeout is " + s.getSoTimeout() + " do receive:");
	    Socket s1 = s.accept();
	    p("Unexpected (but not error), got socket " + s + " re-run me");
	    System.exit(0);
	} catch (InterruptedIOException e) {
	    pe("accept: shouldn't have timed out!");
	} catch (IOException e) {
	    long delta = System.currentTimeMillis() - start;
	    /* this is a bit hokey - look for "losed" in the xception string
	     * to see if we got the right exception
	     */
	    assert(e.getMessage().indexOf("losed") > 0, "wrong exception after close " +
		   e.getMessage());

	    assert(delta < 10000, "awakening from close took too long: " + delta);
	    verbose("correct exception? " + e);
	} catch (Exception e) {
	    pe(e);
	    e.printStackTrace();
	}
	exit();
    }
}
