/*
 * @(#)TcpNoDelayTest.java	1.4 97/03/03
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.net.*;
import java.io.*;
/* tests:
   - getting/setting TCP Nodelay (can verify actual packets w/ snoop)
   - getting/setting options on closed socket (should raise exceptions)
*/

class TcpNoDelayTest extends NetTest {


    static final byte[] msg = { 
	'G', 'E', 'T', ' ', '/', ' ', 'H', 'T', 'T', 'P',
	'/', '1', '.', '0', '\r', '\n', '\r', '\n'
    };
	   
    public TcpNoDelayTest(String[] a) {
	super(a);
    }

    public static void main(String[] a) {
	int iter = 1;
	String[] args = a;
	for (int i = 0; i < a.length; i++) {
	    if (a[i].equals("iter")) {
		iter = Integer.parseInt(a[i+1]);
		args = new String[a.length - 2];
		System.arraycopy(a, 0, args, 0, i);
		System.arraycopy(a, i+2, args, i, a.length - i - 2);
		break;
	    }
	}
	
	for (int i = 0; i < iter; i++) 
	    (new Thread(new TcpNoDelayTest(args), "TCPNoDlay#"+i)).start();
    }

    protected void usage() {
	p("java TcpNoDelayTest [host port] [verbose] [iter <iter-count>");
	p("tests TCP_NODELAY for Socket.  expects to be connected to an HTTP server.");
	p("if no host/port are specified, sunweb.ebay/80 is used.");
	p("iter: # client threads to start");
    }

    public void run() {
	String host;
	int port;
	if(argv.length < 2) {
	    host = "129.150.195.23";
	    port = 80;
	} else {
	    host = argv[0];
	    port = Integer.parseInt(argv[1]);
	}

	try {
	    p(Thread.currentThread().getName()+"> host="+host+", port="+port+", arg.len="+argv.length);
	    verbose("make socket:");
	    Socket s = new Socket(host, port);
	    verbose("Made one: check default TCP_NODELAY:");
	    if (s.getTcpNoDelay()) {
		pe("TcpNodelay on by default");
	    }

	    verbose("set tcp no delay:");
	    s.setTcpNoDelay(true);
	    verbose("TCPNDLAY option set to:" + s.getTcpNoDelay());
	    if (!s.getTcpNoDelay()) {
		pe("Tcp NoDelay off after set");
	    }
	    s.setTcpNoDelay(false);
	    if (s.getTcpNoDelay()) {
		pe("TcpNodelay still on ");
	    }
	    s.setTcpNoDelay(true);
	    if (!s.getTcpNoDelay()) {
		pe("Tcp NoDelay off after set");
	    }
	    verbose("get OK, now send request:");
	    OutputStream os = s.getOutputStream();
	    for (int i = 0; i < msg.length; i++) {
		os.write(msg[i]);
	    }
	    verbose("wrote to server, read response:");
	    DataInputStream dis = new DataInputStream(s.getInputStream());
	    String line;
	    int numLines = 0;
	    while((line = dis.readLine()) != null) {
		// verbose("line: " + line);
		numLines++;
	    }
	    verbose("read "+ numLines + " lines from webpage at http://" + host +":"+port);
	    dis.close();
	    s.close();
	    verbose("Try to get/set options on closed socket, should get exception:");

	    try {
		s.setTcpNoDelay(true);
		pe("should've gotten exception setting ndelay on closed socket");
	    } catch (SocketException e) {
		verbose("got correct error: " + e.getMessage());
	    }

	    try {
		s.setSoLinger(true, 1000);
		pe("should've gotten exception setting linger on closed socket");
	    } catch (SocketException e) {
		verbose("got correct error: " + e.getMessage());
	    }

	    try {
		s.getTcpNoDelay();
		pe("should've gotten exception getting ndelay on closed socket");
	    } catch (SocketException e) {
		verbose("got correct error: " + e.getMessage());
	    }

	    try {
		s.getSoLinger();
		pe("should've gotten exception getting SO_LINGER on closed socket");
	    } catch (SocketException e) {
		verbose("got correct error: " + e.getMessage());
	    }

	} catch (Exception e) {
	    pe(e);
	}
	exit();
    }
}
