/*
 * @(#)UDPBindTest.java	1.3 96/12/22
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.io.*;
import java.net.*;

// tests:
// - binding of DatagramSocket to local port
// - getting BindException for invalid bind host

class UDPBindTest extends NetTest {

    InetAddress bind;
    int port;
    public UDPBindTest (String[] a) {
	super(a);
    }

    protected void usage() {
	p("java UDPBindTest [local-addr local-port] [verbose]");
	p("tests binding DatagramSocket to local address/port.  If none specified a default is used.");
	exit();
    }

    public static void main(String args[]) {
	(new UDPBindTest(args)).run();
    }
    
    public void run() {
	try {

	    if (argv.length > 0) {
		bind = InetAddress.getByName(argv[0]);
		port = Integer.parseInt(argv[1]);
	    } else {
		bind = InetAddress.getLocalHost();
		port = 6787;
	    }
	    
	    verbose("bind to address: " + bind);
	    DatagramSocket d = new DatagramSocket(port, bind);

	    assert(bind.equals(d.getLocalAddress()), 
		   "requested bind address " + bind + " != " + d.getLocalAddress());

	    verbose("dgsock has port: " + d.getLocalPort());
	    assert(port == d.getLocalPort(), "requested local port " + port + " != " +d.getLocalPort());

	    Thread.sleep(10000);
	    // check cannot bind to same port, get BindException
	    DatagramSocket d2 = null;

	    verbose("try to bind to same port, expect exception:");
	    try {
		d2 = new DatagramSocket(port, bind);
		pe("didn't get correct Exception binding to port twice");
	    } catch (BindException e) {
		verbose("got correct Exception " + e);
	    }

	    verbose("try to bind to same port, expect exception:");
	    try {
		d2 = new DatagramSocket(port);
		pe("didn't get correct Exception binding to port twice");
	    } catch (BindException e) {
		verbose("got correct Exception " + e);
	    }

	    // check binding to bogus local address
	    InetAddress in = InetAddress.getByName("128.59.25.1");
	    verbose("try to bind to bogus local address " + in + " expect exception:");
	    try {
		d2 = new DatagramSocket(port+1, in);
		pe("didn't get correct Exception binding to wrong host");
	    } catch (BindException e) {
		verbose("got correct Exception " + e);
	    }

	    // send a packet to original socket, close it, re-open to 
	    // same port/address 
	    d2 = new DatagramSocket();
	    byte[] buf = new byte[10];
	    DatagramPacket p = new DatagramPacket(buf, buf.length, 
		    bind, port);
	    verbose("send to original socket:");
	    d2.send(p);
	    verbose("receive on original socket:");
	    d.receive(p);
	    verbose("received: close/re-open socket:");
	    d.close();
	    d = new DatagramSocket(port, bind);
	    verbose("successfully re-bound to " + bind.getHostAddress()+"/"+port);
	} catch(Exception e) {
	    pe(e);
	} finally {
	    exit();
	}
    }
}
    
