import java.net.*;
import java.io.*;

/* A test to see that one thread can close a DatagramSocket
 * while another thread is in receive(), and that the right
 * thing happens.
 *
 * Actually update the test to do this *multiple* times to
 * verify a fix to a race condition in the way recvfrom()
 * was implemented on green threads. The race caused a
 * deadlock btw the fdmon[] and ASYNC_IO mon. -brown

 * The second test Recv2 is the same as Recv, except
 * that we do not setSoTimeout() on the sockets.  This test
 * might not exit if the bug I'm checking for (a deadlock)
 * exists.  So if this test hangs indefinitely, it's a bug.
 */

public class UDPCloseTest extends NetTest {

    public static void main (String[] a) {
	(new UDPCloseTest(a)).run();
    }

    int count = 5;
    UDPCloseTest(String[] a) {
	super(a);
	for (int i = 0; i < argv.length; i++) {
	    if (argv[i].equals("count") && ++i < argv.length) {
		count=Integer.parseInt(argv[i]);
		verbose("create and close " + count + " sockets.");
	    }
	}
    }

    public void run() {
	DatagramSocket[] arr = new DatagramSocket[count];
	int i;
	try {

	    for (i = 0; i < count; ++i) {
		arr[i] = new DatagramSocket();
		byte[] recvbuf = new byte[200];
		DatagramPacket pack = new DatagramPacket(recvbuf, 200);
		p("port="+arr[i].getLocalPort()+", Start thread to do recvfrom: ");

		Recv r = new Recv(argv, arr[i], pack);
		r.verbose = this.verbose;
		(new Thread(r, "DGRecv thread#"+i)).start();
	    }

	    Thread.sleep(4000); // relinquish CPU for green threads....

	    verbose("try to close datagramsockets:");

	    for (i = 0; i < count; i++) {
		arr[i].close();
	    }

	    Thread.yield(); // relinquish green CPU...
	    p("Try it again, with no timeout:");

	    for (i = 0; i < count; ++i) {
		arr[i] = new DatagramSocket();
		byte[] recvbuf = new byte[200];
		DatagramPacket pack = new DatagramPacket(recvbuf, 200);
		p("port="+arr[i].getLocalPort()+", Start thread to do recvfrom: ");

		Recv2 r = new Recv2(argv, arr[i], pack);
		r.verbose = this.verbose;
		(new Thread(r, "DGRecv thread#"+i)).start();
	    }

	    Thread.sleep(4000); // relinquish CPU for green threads....

	    p("try to close datagramsockets, again:\n\t(if I hang for more than a few seconds, it's a bug):");

	    for (i = 0; i < count; i++) {
		arr[i].close();
	    }
	    verbose("did close, exiting....");
	} catch (Exception e) {
	    pe(e);
	}
	exit();
    }
}

class Recv extends NetTest {

    DatagramSocket s;
    DatagramPacket p;

    Recv (String[] a, DatagramSocket s, DatagramPacket p) {
	super(a);
	this.s = s;
	this.p = p;
    }

    public void run() {
	verbose("Running recv thread");
	long start = System.currentTimeMillis();
	try {
	    s.setSoTimeout(30000);
	    p("soTimeout is " + s.getSoTimeout() + " do receive:");
	    s.receive(p);
	    p("Unexpected (but not error), received packet: " + p+", re-run me");
	    System.exit(0);
	} catch (InterruptedIOException e) {
	    pe("DG receive: shouldn't have timed out!");
	} catch (IOException e) {
	    long delta = System.currentTimeMillis() - start;
	    // this is a bit hokey - look for "losed" in the xception string
	    // to see if we got the right exception
	    assert(e.getMessage().indexOf("losed") > 0, "wrong exception after close " +
		   e.getMessage());
	    assert(delta < 10000, "awakening from close took too long: " + delta);
	    verbose("correct exception? " + e);
	} catch (Exception e) {
	    pe(e);
	    e.printStackTrace();
	}
	exit();
    }
}

/* same as the first, but without soTimeout() set */
class Recv2 extends NetTest {

    DatagramSocket s;
    DatagramPacket p;

    Recv2(String[] a, DatagramSocket s, DatagramPacket p) {
	super(a);
	this.s = s;
	this.p = p;
    }

    public void run() {
	verbose("Running recv thread");
	try {
	    s.receive(p);
	    p("Unexpected (but not error), received packet: " + p+", re-run me");
	    System.exit(0);
	} catch (IOException e) {
	    // this is a bit hokey - look for "losed" in the xception string
	    // to see if we got the right exception
	    assert(e.getMessage().indexOf("losed") > 0, "wrong exception after close " +
		   e.getMessage());
	    verbose("correct exception? " + e);
	} catch (Exception e) {
	    pe(e);
	    e.printStackTrace();
	}
	exit();
    }
}
