import java.net.*;
import java.io.*;

/* Tests that one thread can send() while another thread
 * is blocked in receive().
 */

public class UDPSendTest extends NetTest {

    public static void main(String[] a) {
	(new UDPSendTest(a)).run();
    }

    UDPSendTest(String[] a) {
	super(a);
    }

    DatagramSocket s = null;

    public void run() {
	try {
	    s = new DatagramSocket();
	    verbose("start sender thread:");
	    (new Thread(new Sender(this, argv), "sender")).start();
	    byte[] buf = new byte[10];
	    DatagramPacket p = new DatagramPacket(buf, buf.length);
	    s.setSoTimeout(10000);
	    assert(s.getSoTimeout() == 10000, "timeout wrong on socket");
	    verbose("receive:");
	    
	    try {
		s.receive(p);
	    } catch (InterruptedIOException e) {
		pe("receive shouldn't have timedout");
		pe(e);
		exit();
	    }

	    verbose("got packet - all OK");
	    
	} catch (Exception e) {
	    pe(e);
	}
	exit();
    }
}

class Sender extends NetTest {
    
    Sender(UDPSendTest t, String[] argv) {
	super(argv);
	this.verbose = t.verbose;
	this.t = t;
    }

    UDPSendTest t;

    public void run() {
	try {
	    byte[] buf = new byte[10];
	    DatagramPacket p = new DatagramPacket(
	        buf, buf.length, InetAddress.getLocalHost(), t.s.getLocalPort());
	    verbose("send to "+ p.getAddress()+"/"+p.getPort());
	    
	    t.s.send(p);
	    verbose("done sending");
	} catch (Exception e) {
	    pe(e);
	} 
	exit();
    }
}
    
	    

		
