/*
 * @(#)UDPTimedTest.java	1.2 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.net.*;
import java.io.*;
import java.util.Random;

/*
 * Tests:
 * - SoTimeout for DatagramSocket
 * - DatagramSocket send()/receive(), and all methods in general
 * - DatagramPacket methods in general
 */

public class UDPTimedTest extends NetTest {

    // number of cycles
    int iter = 10;
    // spacing of timeouts - should be > 100
    int spacing = 300;
    // base for timeout mods - timeouts are 0 < timeout < tmod
    int tmod = 500;

    Random rand = new Random(System.currentTimeMillis());

    static final byte[] msg = {
	'A', 'n', 'd', ' ', 't', 'h', 'e', ' ', 'w', 'i', 'n', 'd',
	' ', 'c', 'r', 'i', 'e', 'd', ' ', 'M', 'a', 'r', 'y'
    };

    public static void main(String[] a) {
	(new UDPTimedTest(a)).run();
    }

    public UDPTimedTest(String[] a) {
	super(a);
	for (int i = 0; i < a.length; i++) {
	    if (i == 0 && a[i].length() > 0 && Character.isDigit(a[i].charAt(0))) 
		iter = Integer.parseInt(a[0]);
	    if (a[i].equals("mod")) {
		tmod = Integer.parseInt(a[++i]);
	    } else if (a[i].equals("spacing")) {
		spacing = Integer.parseInt(a[++i]);
	    }
	}
    }

    protected void usage() {
	p("java UDPTimedTest [\"mod\" <mod-time>] [\"spacing\" <spacing-time>] [verbose]");
	p("tests timeout socket option for DatagramSocket");
	p("\tmod: range in ms for socket timeouts - 0 < $(randomTimeout) < mod");
	p("\tspacing: time in ms added to a timeout btw. socket peers.");
	p("\t         (should be > 100 ms to avoid spurious errors).");
	p("\tverbose: verbose output");
	exit();
    }
  

    public synchronized void run() {
	UDPTimedServerTest server = null;
	try {
	    for (int i = 0; i < iter; i++) {
		/* 1st go - no timeouts */
		int r = 0;
		DatagramSocket ss = new DatagramSocket(0, InetAddress.getLocalHost());
		DatagramPacket rcv = new DatagramPacket(new byte[msg.length+100],
					  msg.length+100);
		verbose("DGMain> start server:");
		server = new UDPTimedServerTest(this, argv, ss);
		server.verbose = verbose;
		new Thread(server, "UDPServerTest#"+i).start();
		wait();
		verbose("DGMain> update server:");
		server.updateState(false, false, 0, 0);
		DatagramPacket pack = new DatagramPacket(msg, msg.length,
			       InetAddress.getLocalHost(), ss.getLocalPort());

		DatagramSocket s = new DatagramSocket(0, InetAddress.getLocalHost());
		s.setSoTimeout(r);
		if (s.getSoTimeout() != r) {
		    pe("requested timeout " + r + " != " + s.getSoTimeout());
		}
		verbose("DGMain> send packet:");
		s.send(pack);
		
		verbose("DGMain> rcv packet:");
		s.receive(rcv);
		
		/*		if (rcv.getPort() != s.getLocalPort()) {
		    pe("packet port != socket port: " + rcv.getPort() +" != " +
		       s.getLocalPort());
		}
		*/
		if (!(rcv.getAddress().equals(s.getLocalAddress()))) {
		    pe("socket address != packet address: " + s.getLocalAddress() + " != "
		       + rcv.getAddress());
		}
		if (rcv.getLength() != msg.length) {
		    pe("packet len != msg len: " + rcv.getLength() + " != " +
		       msg.length);
		}
		byte[] recv = rcv.getData();
		for (int j = 0; j < msg.length; j++) {
		    if (recv[j] != msg[j]) {
			pe("received unexpected byte in position " + j);
		    }
		}
		
		/* 2nd go - expect client timeout */
		r = getRand();
		verbose("DGMain> wait 2nd time:");
		wait();
		server.updateState(false, false, r + spacing, 0);
		s.setSoTimeout(r);
		if (s.getSoTimeout() != r) {
		    pe("requested timeout " + r + " != " + s.getSoTimeout());
		}
		verbose("DGMain> send packet:");
		s.send(pack);

		try {
		    verbose("DGMain> rcv packet:");
		    s.receive(rcv);
		    pe("DGMain> expected to timeout!");
		} catch (InterruptedIOException e) {
		    verbose("DGMain> got expected exception: " + e);
		}

		/* 3rd go - server should timeout */
		verbose("DGMain> 3rd iter- server should timeout");
		wait();
		server.updateState(true, true, getRand(), getRand());
		verbose("DGMain> move to next iter");
	    }
	} catch (Exception e) {
	    pe(e);
	    server.die();
	} finally {
	    exit();
	    return;
	}
    }

    int getRand() {
	int r = rand.nextInt() % tmod;
	if (r < 0)
	    r = -r;
	return r+spacing;
    }
}

class UDPTimedServerTest extends NetTest {

    UDPTimedTest him;
    DatagramSocket s;
    boolean expectTimeout = false;
    boolean expectDeath = false;
    boolean die = false;
    int sleep = 0;
    int timeout = 0;

    static final byte[] msg = {
	'A', 'n', 'd', ' ', 't', 'h', 'e', ' ', 'w', 'i', 'n', 'd',
	' ', 'c', 'r', 'i', 'e', 'd', ' ', 'M', 'a', 'r', 'y'
    };

    synchronized void updateState(boolean exT, boolean exD, int sleep, int time) {
	expectTimeout = exT;
	expectDeath = exD;
	this.sleep = sleep;
	timeout = time;
	notify();
    }

    synchronized void die() {
	die = true;
	notify();
    }

    UDPTimedServerTest(UDPTimedTest him, String[] a, DatagramSocket s) {
	super(a);
	this.him = him;
	this.s = s;
    }

    public synchronized void run() {
	byte[] buf = new byte[msg.length + 100];
	DatagramPacket pack = new DatagramPacket(buf, buf.length);
	verbose("DGserver> starting");
	while(true) {
	    try {
		verbose("DGserver> notify peer:");
		synchronized (him) {
		    him.notify();
		}
		verbose("DGserver> wait:");
		wait();
		verbose("DGserver> proceed");
		if (die) {
		    pe("Unxpected death");
		    exit();
		    return;
		}
		s.setSoTimeout(timeout);
		if (s.getSoTimeout() != timeout) {
		    pe("requested timeout " + timeout + " != " + s.getSoTimeout());
		}
		if (!(s.getLocalAddress().equals(InetAddress.getLocalHost()))) {
		    pe("socket address != local address: " + s.getLocalAddress() + " != " + 
		       InetAddress.getLocalHost());
		}
		verbose("DGServer> receive:");
		s.receive(pack);

		verbose("DGServer> received from " + pack.getAddress() + "/" + pack.getPort());
		if (!(s.getLocalAddress().equals(pack.getAddress()))) {
		    pe("socket address != packet address: " + s.getLocalAddress() + " != "
		       + pack.getAddress());
		}
		if (pack.getLength() != msg.length) {
		    pe("packet len != msg len: " + pack.getLength() + " != " +
		       msg.length);
		}
		byte[] recv = pack.getData();
		for (int i = 0; i < msg.length; i++) {
		    if (recv[i] != msg[i]) {
			pe("received unexpected byte in position " + i);
		    }
		}
		verbose("DGServer> sleep for " + sleep);
		Thread.sleep(sleep);
		DatagramPacket pack2 = new DatagramPacket(msg, msg.length,
					   pack.getAddress(), pack.getPort());
		
		s.send(pack2);

	    } catch (InterruptedIOException e) {
		if (!expectTimeout) {
		    pe("DGServer> didn't expect timeout");
		} else {
		    verbose("DGServer> got expected timeout");
		} 
		if (expectDeath) {
		    break;
		}
	    } catch (Exception e) {
		pe(e);
		break;
	    } 
	}
	exit();
    }
}
		    
		

