#!/bin/sh
#
# run me as "sh netTests.sh"
# 
rm -rf .fail.list
rm -rf *.log

TESTS='HttpTest ClientBindTest MulticastTest
 IANumberTest NullPtrTest TcpNoDelayTest SocketTimedTest
 UDPBindTest UDPTimedTest UDPSendTest UDPCloseTest TCPCloseTest';

for t in $TESTS
do
  echo; echo; echo $t
  if [ ! -f ${t}.class ] ; then
    echo compiling ${t}.java
    if javac ${t}.java ; then
      true;
    else 
      echo "compilation failed";
      exit 1;
    fi
  fi
  
  if  java $t ; then
    true;
  else
    echo "FAILED!";
    echo java $t >> .fail.list;
  fi
done

if [ ! -f .fail.list ] ; then
  echo "All passed!";
else
  echo "failed:";
  cat .fail.list;
fi

