/*
 * @(#)AppleEvent.java	1.1 97/03/13
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_pre-beta
 */

import java.util.Date;

/**
 * The AppleEvent class is simply an object to be passed back to a
 * remote objct exported by an applet to verify proper object
 * serialization.
 */
public class AppleEvent implements java.io.Serializable {

    public static final int BUY   = 0;
    public static final int EAT   = 1;
    public static final int THROW = 2;

    private int what;

    private java.util.Date when;

    public AppleEvent(int what)
    {
	this.what = what;
	this.when = new Date();
    }

    public String toString()
    {
	String desc = "[";
	switch (what) {
	case BUY:
	    desc += "BUY";
	    break;
	case EAT:
	    desc += "EAT";
	    break;
	case THROW:
	    desc += "THROW";
	    break;
	}
	desc += " @ " + when + "]";
	return desc;
    }
}
