/*
 * @(#)AppleImpl.java	1.1 97/03/13
 *
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.1_pre-beta
 */

import java.rmi.*;
import java.rmi.server.*;

import java.awt.*;

/**
 * The AppleImpl class implements the behavior of the remote "apple"
 * objects exported by the applet.
 */
public class AppleImpl
    extends UnicastRemoteObject
    implements Apple
{

    String name;
    JuicerDisplay display;

    public AppleImpl(String name, JuicerDisplay display)
	throws RemoteException
    {
	this.name    = name;
	this.display = display;
    }

    /**
     * Receive an array of AppleEvent objects.
     */
    public void notify(AppleEvent[] events)
    {
	try {
	    String threadName = Thread.currentThread().getName();

	    for (int i = 0; i < events.length; ++ i)
		display.appendText(
		    toString() +
			"'s notify() method: events[" + i + "] = " +
			events[i].toString() + "\n");

	} catch (RuntimeException e) {
	    synchronized (System.err) {
		System.err.print("AppleImpl.notify(): ");
		e.printStackTrace();
	    }
	    throw e;
	}
    }

    public void printlnToAppletDisplay(String s)
    throws RemoteException
    {
        try
        {
	        System.out.println(s);
	        display.appendText(s + "\n");
        }
        catch (RuntimeException e)
        {
	        synchronized (System.err)
	        {
		        System.err.print("AppleImpl.printlnToAppletDisplay(): ");
		        e.printStackTrace();
	        }
	        throw e;
	    }
    }
    /**
     * Return a newly created and exported orange implementation.
     */
    public Orange newOrange(String name, int numIterations)
	throws RemoteException
    {
	try {
	    String threadName = Thread.currentThread().getName();

	    Orange orange = new OrangeImpl(name, display);

	    //display.appendText(
		//threadName + ": " + toString() +
		//".newOrange(" + name + "): END\n");
        display.appendText(
		    name + " on iteration #" + numIterations +
		    " called remote method - newOrange.  Orange creation was successful!" + "\n");

	    return orange;
	} catch (RuntimeException e) {
	    synchronized (System.err) {
		System.err.print("AppleImpl.newOrange(): ");
		e.printStackTrace();
	    }
	    throw e;
	}
    }

    public String toString()
    {
	return name;
    }
}
