/*
 * @(#)AppleUserImpl.java	1.3 97/07/30
 *
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.1_pre-beta
 */

import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.*;
import java.util.*;
import java.io.*;

/**
 * The AppleUserImpl class implements the behavior of the remote "apple
 * user" objects exported by the server.  The applet registers its
 * remote "apple" objects with an apple user, and an AppleUserThread
 * is created for each.
 */
public class AppleUserImpl
    extends UnicastRemoteObject
    implements AppleUser
{
    Vector vThreadHandles;
    static int threadNum = 0;
    ConfigurationSettings configuration;
    Apple appleRef;
    static FileOutputStream jLogFileStream;
    static boolean bLogFileExists = false;
    static boolean bExceptionWasThrown = false;


    public AppleUserImpl()
	throws RemoteException
    {
        vThreadHandles = new Vector();

        try
        {
            AppleUserImpl.jLogFileStream = new FileOutputStream("jlog.txt");
            bLogFileExists = true;
        }
        catch(IOException e)
        {
            System.err.print("Failed to open logfile, jlog.txt!");
	        e.printStackTrace();
        }
    }

    public static synchronized void WriteToFile(Exception eArg)
    {
        bExceptionWasThrown = true;

        if(bLogFileExists)
        {
            String s = new String(eArg.getMessage());
            byte[] buffer = new byte[s.length()];
            s.getBytes(0, s.length(), buffer, 0);

            //PrintStream pst = new PrintStream(AppleUserImpl.jLogFileStream);

            try
            {
                AppleUserImpl.jLogFileStream.write(buffer);
                //eArg.printStackTrace(pst);
                AppleUserImpl.jLogFileStream.flush();
                AppleUserImpl.jLogFileStream.close();
                bLogFileExists = false;
                System.err.print("Wrote " + s + " to jlog.txt");
                System.out.println("Wrote " + s + " to jlog.txt");
                System.out.println(eArg.getMessage());
                eArg.printStackTrace();
            }
            catch(IOException e)
            {
                System.err.print("Failed to write to logfile, jlog.txt!");
	            e.printStackTrace();
            }
        }
    }

    /**
     * "Use" supplied apple object.  Create a AppleUserThread to
     * stress it out.
     */
    public synchronized void useApple(Apple apple, ConfigurationSettings config)
	throws RemoteException
    {
	configuration = config;
	appleRef = apple;
	String threadName = Thread.currentThread().getName();
	System.out.println(threadName + ": AppleUserImpl.useApple(): BEGIN");
	AppleUserThread t =
	    new AppleUserThread("AppleUserThread-" + ++ threadNum, apple, config);
	vThreadHandles.addElement(t);

	t.start();
	System.out.println(threadName + ": AppleUserImpl.useApple(): END");
    }

    public void RegisterCallBackWhenDone(AppletServerRemote theApplet)
    throws RemoteException
    {
        ServerMonitorThread t = new ServerMonitorThread(vThreadHandles, theApplet);
        t.start();
    }

    /**
     * Method to stop all of the threads
     */
    public boolean StopUsingApples() throws RemoteException
    {
        int iThreadCount = vThreadHandles.size();
        AppleUserThread t;
        boolean bThreadIsStopped;
        boolean bReturnVal = true;

        for(int ii = 0; ii < iThreadCount; ii++)
        {
            t = (AppleUserThread)vThreadHandles.elementAt(ii);
            bThreadIsStopped = t.StopThread();

            if(bThreadIsStopped)
            {
                System.out.println(t.getName() + " stopped successfully!");
                appleRef.printlnToAppletDisplay(t.getName() + " stopped successfully!");
            }
            else
            {
                System.out.println(t.getName() + " failed to stop!");
                appleRef.printlnToAppletDisplay(t.getName() + " failed to stop!");
                bReturnVal = false;
            }

        }
        return bReturnVal;
    }

    public void ResetRemoteVariables()
    throws RemoteException
    {
        vThreadHandles.removeAllElements();
        threadNum = 0;
    }

    /**
     * Entry point for "juicer" server process.  Create and export
     * an apple user implmentation.
     */
    public static void main(String[] args)
    {
	System.setSecurityManager(new RMISecurityManager());

	try {
	    LocateRegistry.createRegistry(Registry.REGISTRY_PORT);
	    System.out.println("AppleUserImpl:  Registry has been created");
	    AppleUserImpl user = new AppleUserImpl();
	    Naming.rebind("AppleUser", user);
	    System.out.println("AppleUserImpl:  AppleUser has been bound to the Registry");
	} catch (RemoteException e) {
	    System.err.print("Failed to create AppleUser: ");
	    e.printStackTrace();
	} catch (java.net.MalformedURLException e) {
	    System.err.print("Failed to bind AppleUser: ");
	    e.printStackTrace();
	}
    }
}

/*
 * This Class serves the purpose of waiting for all of the appleuserthreads
 * to exit.  This info is then passed back to the Applet via RMI.
 */
class ServerMonitorThread extends Thread
{
    Vector vThreads;
    AppleUserThread t;
    AppletServerRemote appletRef;

    public ServerMonitorThread(Vector vThreadHandles, AppletServerRemote theApplet)
    {
        vThreads = vThreadHandles;
        appletRef = theApplet;
    }

    public void run()
    {
        for(int ii = 0; ii < vThreads.size(); ii++)
        {
            t = (AppleUserThread)vThreads.elementAt(ii);
            try
            {
                t.join();
            }
            catch(InterruptedException e)
            {
                synchronized (System.err)
                {
		            System.err.print(
		                "Failed waiting for the thread to die!");
		            e.printStackTrace();
                }
                AppleUserImpl.WriteToFile(e);
            }
        }

        try
        {
	        appletRef.notifyThatAllThreadsAreDone(AppleUserImpl.bExceptionWasThrown);
	    }
	    catch (RemoteException e) {
	        synchronized (System.err) {
		    System.err.print(
		        "Failed to notify applet that all threads have finished");
		    e.printStackTrace();
	        }
	    }
    }
}

/**
 * The AppleUserThread class repeatedly invokes calls on its associated
 * Apple object to stress the RMI system.
 */
class AppleUserThread extends Thread
{
    static Random random = new Random();

    Apple apple;
    ConfigurationSettings configInfo;
    int iNumberOfIterations;
    boolean bStopButtonWasPressed;

    public AppleUserThread(String name, Apple apple, ConfigurationSettings config)
    {
	    super(name);
	    this.apple = apple;
	    bStopButtonWasPressed = false;
	    configInfo = config;
	    if(configInfo.sCurrentIteration.equalsIgnoreCase("Forever"))
		{
		    iNumberOfIterations = -1;
		}
		else
		{
		    iNumberOfIterations = configInfo.iIterationExactlyVal;
		}
    }


    public boolean StopThread()
    {
        bStopButtonWasPressed =  true;
        while(this.isAlive())
            {
            }
        return true;
    }

    public void run()
    {
	boolean problem = false;
	int orangeNum = 0;
    int[] message;
    int[] response;
    int iNumberOfTimesThrough = 0;

	while (!problem && !bStopButtonWasPressed) {
	    if(iNumberOfIterations < 0)
		{
		    //go on until there is a problem
		}
		else
		{
		    if(iNumberOfIterations == 0)
		    {

	            synchronized(System.out)
	            {
	                System.out.println(getName() +
	                    " has completed " + iNumberOfTimesThrough + " iteration(s)");
	                try
	                {
	                    apple.printlnToAppletDisplay(getName() +
	                        " has completed " + iNumberOfTimesThrough +
	                        " iteration(s)");
	                }
	                catch (RemoteException e)
	                {
	                    synchronized (System.err)
	                    {
	                        System.err.println("Remote exception: ");
	                        e.printStackTrace();
	                    }
	                    //print the output to a file if we can
                        AppleUserImpl.WriteToFile(e);
	                }
	            }

		        break;
		    }
		    iNumberOfTimesThrough++;

		    synchronized(System.out)
		    {
		        System.out.println(getName() +
		            " is beginning iteration #" + iNumberOfTimesThrough);
		        try
		        {
		            apple.printlnToAppletDisplay(getName() +
		                " is beginning iteration #" +
		                iNumberOfTimesThrough);
		        }
		        catch (RemoteException e)
		        {
		            synchronized (System.err)
		            {
		                System.err.println("Remote exception: ");
		                e.printStackTrace();
		            }
		            //print the output to a file if we can
                    AppleUserImpl.WriteToFile(e);
		        }
		    }

		    iNumberOfIterations--;
		}

	    try {

		/*
		 * notify apple with some apple events
		 */
		AppleEvent[] events =
		    new AppleEvent[Math.abs(random.nextInt() % 5)];
		for (int i = 0; i < events.length; ++ i)
		    events[i] = new AppleEvent(orangeNum % 3);

		apple.notify(events);

		/*
		 * request a new orange object created in the applet
		 */
		Orange orange = apple.newOrange(getName(), ++ orangeNum);

		/*
		 * create large message of random ints to pass to orange
		 * The size of the message array is specified by the configuration.
		 */
		if(configInfo.sCurrentMessageSize.equalsIgnoreCase("Random %"))
		{
		    int ii = random.nextInt();

		    if(ii % configInfo.iMessageSizeRandomVal != 0)
		    {
		        message =
		            new int[Math.abs(ii % configInfo.iMessageSizeRandomVal)];
		            //original juicer had:  random.nextInt() % 3000
		    }
		    else
		    {
		        message =
		            new int[1000];  //default to arraysize 1000 if above = 0
		    }
		}
		else
		{
		    int ii = random.nextInt();

		    if(configInfo.iMessageSizeExactlyVal != 0)
		    {
		        message =
		            new int[Math.abs(configInfo.iMessageSizeExactlyVal)];
		    }
		    else
		    {
		        message =
		            new int[1000];  //default to arraysize 1000 if above = 0
		    }
		}

		for (int i = 0; i < message.length; ++ i)
		    message[i] = random.nextInt();

		/*
		 * invoke recursive call on the orange
		 */
		OrangeEchoImpl echo =
		    new OrangeEchoImpl("OrangeEcho(" + getName() + ")-" +
			orangeNum);

		/*
		 * Based on the config info, use a random number or set number of
		 * recursions.  If the last parameter = 0, that's OK, there just won't be any recursive calls
		 */
		if(configInfo.sCurrentRecursion.equalsIgnoreCase("Random %"))
		{
		    response = orange.recurse(echo, message,
			        Math.abs(random.nextInt() % configInfo.iRecursionRandomVal));
		}
		else
		{
		    response = orange.recurse(echo, message,
			        Math.abs(configInfo.iRecursionExactlyVal));
		}

		/*
		 * verify message was properly inverted and not corrupted
		 * through all the recursive method invocations
		 */
		if (response.length != message.length) {
		    System.err.println("ERROR: CORRUPTED RESPONSE: " +
			"wrong length of returned array " +
			"(should be " + message.length +
			", is " + response.length + ")");

			apple.printlnToAppletDisplay("ERROR: CORRUPTED RESPONSE: " +
			    "wrong length of returned array " +
			    "(should be " + message.length +
			    ", is " + response.length + ")");
		    break;
		}
		for (int i = 0; i < message.length; ++ i) {
		    if (~message[i] != response[i]) {
			System.err.println("ERROR: CORRUPTED RESPONSE: " +
			    "at element " + i + "/" + message.length +
			    " of returned array " +
			    "(should be " + Integer.toHexString(~message[i]) +
			    ", is " + Integer.toHexString(response[i]) + ")");

			apple.printlnToAppletDisplay("ERROR: CORRUPTED RESPONSE: " +
			    "at element " + i + "/" + message.length +
			    " of returned array " +
			    "(should be " + Integer.toHexString(~message[i]) +
			    ", is " + Integer.toHexString(response[i]) + ")");
		    }
		}




	    } catch (RemoteException e) {
		synchronized (System.err) {
		    System.err.println("Remote exception: ");
		    e.printStackTrace();
		}
		//print the output to a file if we can
	    AppleUserImpl.WriteToFile(e);
		problem = true;
	    }
	    try {
		Thread.sleep(Math.abs(random.nextInt() % 10) * 1000);
	    } catch (InterruptedException e) {
	    }
	}
    }
}

