/*
 * @(#)AppletServer.java	1.4 97/09/10
 *
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.1_pre-beta
 */

import java.rmi.*;
import java.rmi.server.*;
import java.awt.*;
import java.lang.*;
import java.net.*;


/**
 * The AppletServer class provides the applet side of the "juicer"
 * stress test of RMI.
 */
public class AppletServer extends java.applet.Applet
    implements AppletServerRemote,
    Runnable{

    //UI controls used to retrieve config information
    JuicerDisplay   display;
    Thread          juicerThread;
    Button          startButton;
    Button          stopButton;
    Button          clearButton;
    Label           optionsLabel;
    Label           threadLabel;
    Label           messageLabel;
    Label           recursionLabel;
    Label           iterationLabel;
    TextField       threadField;
    TextField       messageSizeRandomField;
    TextField       messageSizeExactlyField;
    TextField       recursionRandomField;
    TextField       recursionExactlyField;
    TextField       iterationExactlyField;
    CheckboxGroup   messageSizeGroup;
    CheckboxGroup   recursionGroup;
    CheckboxGroup   iterationGroup;
    Checkbox        rbMessageSizeRandom;
    Checkbox        rbMessageSizeExactly;
    Checkbox        rbRecursionRandom;
    Checkbox        rbRecursionExactly;
    Checkbox        rbIterationForever;
    Checkbox        rbIterationExactly;
    Panel           pControlPanel;

    ConfigurationSettings configuration;
    String          sServerHost;
    boolean         bRunningAsAnApplication;
    boolean         bServerReturned;
    boolean         bExceptionFromServerWasThrown;

    final static int START_BUTTON_WAS_PRESSED = 1;
    final static int STOP_BUTTON_WAS_PRESSED  = 2;
    final static int ALL_THREADS_HAVE_STOPPED  = 3;

    /** number of remote Apple objects to export */
    int iNumApples;

    AppleImpl[] apples;

    AppleUser user;

    /*
     * On applet initialization, export remote objects and register
     * them with server.
     */
    public void init()
    {
	    bRunningAsAnApplication = false;
	    InitializeApp();
    }

    public void InitializeApp()
    {
        try
	    {
	        UnicastRemoteObject.exportObject(this);
	    }
	    catch(RemoteException e)
	    {
	        synchronized (System.err)
	        {
		        System.err.print(
		            "Failed to export the Applet's remote interface!");
		        e.printStackTrace();
	        }
	        finish(true);
	    }

	    bServerReturned = false;
	    bExceptionFromServerWasThrown = false;
	    addControls();
        configuration = new ConfigurationSettings();

        //initialize controls
        threadField.setText("5");
        messageSizeRandomField.setText("20000");
        messageSizeExactlyField.setText("20000");
        recursionRandomField.setText("3");
        recursionExactlyField.setText("3");
        iterationExactlyField.setText("1");

    }

    /*
	 * Needed to run in batch mode as an application!
	 */
    public static void main(String[] args)
    {
        System.setSecurityManager(new RMISecurityManager());
        
        AppletServer JuicerClient = new AppletServer();
        JuicerClient.bRunningAsAnApplication = true;
        JuicerClient.GetCommandLineArguments(args);
        if(JuicerClient.sServerHost == null)
        {
            try
            {
                JuicerClient.sServerHost = InetAddress.getLocalHost().getHostName();
            }
            catch (java.net.UnknownHostException e)
            {
	            synchronized (System.err)
	            {
		            System.err.print("Failed to get local hostname.");
		            e.printStackTrace();
	            }
	            JuicerClient.finish(true);
	        }
        }


        JuicerClient.InitializeApp();
        JuicerClient.juicerThread = new Thread(JuicerClient);
        JuicerClient.juicerThread.start();
        System.out.println("Beginning Juicer Client as an Application");
    }

    void GetCommandLineArguments(String[] args)
    {
        for(int ii = 0; ii < (args.length - 1); ii++)
        {
            if(args[ii].equals("-host"));
            {
                sServerHost = new String(args[++ii]);
            }
        }
    }

    public void run()
    {
        getOptionValues();
        apples = new AppleImpl[iNumApples];
        int i = 0;
        String url;

        /*
	    * create and export apple implementations
	    */
	    try {
	        for (i = 0; i < iNumApples; ++ i)
	    	apples[i] = new AppleImpl("AppleImpl #" + (i + 1), display);
	    } catch (RemoteException e) {
	        synchronized (System.err) {
		    System.err.print(
		        "Failed to create AppleImpl #" + (i + 1) + ": ");
		    e.printStackTrace();
	        }
	        finish(true);
	        return;
	    }

	    /*
	     * locate apple user object on server
	     */
        try
        {
            juicerThread.sleep(10000);  //sleep to give the server time to bind
        }
        catch (InterruptedException e)
        {}

	    if(bRunningAsAnApplication)
	    {
	        url = "rmi://" + sServerHost + "/AppleUser";
	    }
	    else
	    {
	        url = "rmi://" + getCodeBase().getHost() + "/AppleUser";
	    }
	    try {
	        user = (AppleUser) Naming.lookup(url);
	        display.appendText("Name Lookup of AppleUser object succeeded!" + "\n");
	        System.out.println("Name Lookup of AppleUser object succeeded!" + "\n");
	    } catch (Exception e) {
	        synchronized (System.err) {
		    System.err.print("Failed to lookup AppleUser: ");
		    e.printStackTrace();
	        }
	        finish(true);
	        return;
	    }

        try {
		    user.ResetRemoteVariables();
	    } catch (RemoteException e) {
	        synchronized (System.err) {
		    System.err.print(
		        "Failed to reset remote variables!");
		    e.printStackTrace();
	        }
	        finish(true);
	        return;
	    }

	    /*
	     * hand apple objects to apple user
	     */
	    try {
	        for (i = 0; i < iNumApples; ++ i)
	        {
	            apples[i].printlnToAppletDisplay("Calling Server Method - useApple() with apple #" +
	                (i+1));
	            System.out.println("Calling Server Method - useApple() with apple #" + (i+1));
		        user.useApple(apples[i], configuration);
		    }
	    } catch (RemoteException e) {
	        synchronized (System.err) {
		    System.err.print(
		        "Failed to register callbacks for " + apples[i] + ": ");
		    e.printStackTrace();
	        }
	        finish(true);
	        return;
	    }

	    /*
	     * Pass the Applet object to the server so it can monitor
	     * the threads and tell us when it's done
	     */
	    try {
	        user.RegisterCallBackWhenDone(this);
	    } catch (RemoteException e) {
	        synchronized (System.err) {
		    System.err.print(
		        "Failed to register callback to tell us when the threads have finished");
		    e.printStackTrace();
	        }
	        finish(true);
	        return;
	    }

        if(bRunningAsAnApplication)
        {
            try
            {
                for(int ii = 0; ii < 480; ii++)
                {
                    juicerThread.sleep(1000);  //sleep for 8 minutes, then timeout
                    if(bServerReturned)
                        break;
                }
            }
            catch (InterruptedException e)
            {
                e.printStackTrace();
            }
    	    if(!bServerReturned)
    	        System.out.println("Juicer timed-out waiting for the server to return!");
    	    bServerReturned = false;
    	    finish(bExceptionFromServerWasThrown);
    	}
    }

    public boolean handleEvent(Event event) {
		if (event.target == startButton && event.id == Event.ACTION_EVENT) {
			startButton_Clicked(event);
			return true;
		}
		if (event.target == stopButton && event.id == Event.ACTION_EVENT) {
			stopButton_Clicked(event);
			return true;
		}
		if (event.target == clearButton && event.id == Event.ACTION_EVENT) {
			clearButton_Clicked(event);
			return true;
		}
		return super.handleEvent(event);
	}

    void startButton_Clicked(Event event)
    {
        updateGUIControls(START_BUTTON_WAS_PRESSED);
        juicerThread = new Thread(this);
        juicerThread.start();

	}

    /*
     * Stop all remote threads from executing
     */
    void stopButton_Clicked(Event event)
    {
        try
        {
	        updateGUIControls(STOP_BUTTON_WAS_PRESSED);
	        user.StopUsingApples();
	    }
	    catch (RemoteException e)
	    {
	        synchronized (System.err)
	        {
		        System.err.print(
		            "Failed to make call to stop remote threads ");
		        e.printStackTrace();
		    }
	    }
	}

    void clearButton_Clicked(Event event)
    {
        synchronized(display)
        {
            display.clear();
        }
    }

    public void updateGUIControls(int iWhereAmI)
    {
        switch(iWhereAmI)
        {
            case START_BUTTON_WAS_PRESSED:
                startButton.enable(false);
                stopButton.enable(true);
                break;
            case STOP_BUTTON_WAS_PRESSED:
                stopButton.enable(false);
                break;
            case ALL_THREADS_HAVE_STOPPED:
                startButton.enable(true);
                stopButton.enable(false);
                break;
        }

    }

	public void notifyThatAllThreadsAreDone(boolean bExceptionWasThrown)
	throws RemoteException
	{
	    bExceptionFromServerWasThrown = bExceptionWasThrown;
	    bServerReturned = true;
	}

	void finish(boolean bExceptionWasThrown)
	{
	    updateGUIControls(ALL_THREADS_HAVE_STOPPED);

	    //If we're running as an application, then Exit with Pass (0) or Fail (1)
	    if(bRunningAsAnApplication)
	    {
    	    if(!bExceptionWasThrown)
    	    {
    	        System.out.println("The Juicer executed successfully!");
    	        System.exit(0);
    	    }
    	    else
    	    {
    	        System.out.println("The juicer terminated abnormally!");
    	        System.exit(1);
    	    }
    	}
	}

	void getOptionValues()
	{
	    /*
	     *Get the configuration values from the gui controls
	     */
	    configuration.iThreadVal = Integer.parseInt(threadField.getText());
        configuration.iMessageSizeRandomVal = Integer.parseInt(messageSizeRandomField.getText());
        configuration.iMessageSizeExactlyVal = Integer.parseInt(messageSizeExactlyField.getText());
        configuration.iRecursionRandomVal = Integer.parseInt(recursionRandomField.getText());
        configuration.iRecursionExactlyVal = Integer.parseInt(recursionExactlyField.getText());
        configuration.iIterationExactlyVal = Integer.parseInt(iterationExactlyField.getText());
        configuration.sCurrentMessageSize = messageSizeGroup.getCurrent().getLabel();
        configuration.sCurrentRecursion = recursionGroup.getCurrent().getLabel();
        configuration.sCurrentIteration = iterationGroup.getCurrent().getLabel();

        iNumApples = configuration.iThreadVal;
	}

    void CreateControlPanel(Panel p)
    {
        //set layout = null
        p.setLayout(null);

        startButton = new Button("Start");
        p.add(startButton);
        startButton.reshape(9,41,72,24);

        stopButton = new Button("Stop");
        p.add(stopButton);
        stopButton.reshape(9,76,72,24);

        clearButton = new Button("Clear");
        p.add(clearButton);
        clearButton.reshape(9,147,72,24);

        optionsLabel = new Label("Options:");
        p.add(optionsLabel);
        optionsLabel.reshape(213,19,72,17);

        threadLabel = new Label("Number of Threads:");
        p.add(threadLabel);
        threadLabel.reshape(221,50,132,17);

        threadField = new TextField();
        p.add(threadField);
        threadField.reshape(372,52,36,23);


        //Add Array Message Size Choices
        messageLabel = new Label("Message Array Size:");
        p.add(messageLabel);
        messageLabel.reshape(221,85,132,17);

        messageSizeGroup = new CheckboxGroup();

        rbMessageSizeRandom = new Checkbox("Random %", messageSizeGroup, false);
        p.add(rbMessageSizeRandom);
        rbMessageSizeRandom.reshape(284,112,86,17);

        messageSizeRandomField = new TextField();
        p.add(messageSizeRandomField);
        messageSizeRandomField.reshape(372,110,36,23);

        rbMessageSizeExactly = new Checkbox("Exactly", messageSizeGroup, true);
        p.add(rbMessageSizeExactly);
        rbMessageSizeExactly.reshape(286,140,86,17);

        messageSizeExactlyField = new TextField();
        p.add(messageSizeExactlyField);
        messageSizeExactlyField.reshape(372,137,36,23);


        //Add Recursion Level Choices
        recursionLabel = new Label("Recursion Level:");
        p.add(recursionLabel);
        recursionLabel.reshape(221,173,132,17);

        recursionGroup = new CheckboxGroup();

        rbRecursionRandom = new Checkbox("Random %", recursionGroup, false);
        p.add(rbRecursionRandom);
        rbRecursionRandom.reshape(284,199,86,17);

        recursionRandomField = new TextField();
        p.add(recursionRandomField);
        recursionRandomField.reshape(372,197,36,23);

        rbRecursionExactly = new Checkbox("Exactly", recursionGroup, true);
        p.add(rbRecursionExactly);
        rbRecursionExactly.reshape(285,227,86,17);

        recursionExactlyField = new TextField();
        p.add(recursionExactlyField);
        recursionExactlyField.reshape(372,226,36,23);


        //Add Iteration Choices
        iterationLabel = new Label("Number of Iterations:");
        p.add(iterationLabel);
        iterationLabel.reshape(433,56,132,17);

        iterationGroup = new CheckboxGroup();

        rbIterationForever = new Checkbox("Forever", iterationGroup, false);
        p.add(rbIterationForever);
        rbIterationForever.reshape(493,82,86,17);

        rbIterationExactly = new Checkbox("Exactly", iterationGroup, true);
        p.add(rbIterationExactly);
        rbIterationExactly.reshape(493,110,65,17);

        iterationExactlyField = new TextField();
        p.add(iterationExactlyField);
        iterationExactlyField.reshape(565,110,36,23);
    }

	void addControls()
	{
	    setLayout(null);
        setBackground(new Color(12632256));

	    pControlPanel = new Panel();
	    pControlPanel.reshape(12, 9, 606, 250);
	    CreateControlPanel(pControlPanel);
        add(pControlPanel);
        display = new JuicerDisplay();
        add(display);
        display.reshape(9,282,607,273);
	}
}


