/*
 * @(#)OrangeEchoImpl.java	1.1 97/03/13
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_pre-beta
 */

import java.rmi.*;
import java.rmi.server.*;

import java.awt.*;

/**
 * The OrangeEchoImpl class implements the behavior of the remote "orange
 * echo" objects exported by the server.  The purpose of these objects
 * is simply to recursively call back to their caller.
 */
public class OrangeEchoImpl
    extends UnicastRemoteObject
    implements OrangeEcho
{

    String name;

    public OrangeEchoImpl(String name)
	throws RemoteException
    {
	this.name = name;
    }

    /**
     * Call back on supplied "orange" object (presumably the caller)
     * with the same message data and a decremented recursion level.
     */
    public int[] recurse(Orange orange, int[] message, int level)
	throws RemoteException
    {
	String threadName = Thread.currentThread().getName();
	System.err.println(
	    threadName + ": " + toString() +
	    ".recurse(message[" + message.length + "], " +
	    level + "): BEGIN");

	int[] response = orange.recurse(this, message, level - 1);

	System.err.println(
	    threadName + ": " + toString() +
	    ".recurse(message[" + message.length + "], " +
	    level + "): END\n");

	return response;
    }

    public String toString()
    {
	return name;
    }
}
