/*
 * @(#)OrangeImpl.java	1.1 97/03/13
 *
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.1_pre-beta
 */

import java.rmi.*;
import java.rmi.server.*;
import java.awt.*;

/**
 * The OrangeImpl class implements the behavior of the remote "orange"
 * objects exported by the applet.
 */
public class OrangeImpl
    extends UnicastRemoteObject
    implements Orange
{

    String name;

    JuicerDisplay display;

    public OrangeImpl(String name, JuicerDisplay display)
	throws RemoteException
    {
	this.name    = name;
	this.display = display;
    }

    /**
     * Return inverted message data, call through supplied OrangeEcho
     * object if not at recursion level zero.
     */
    public int[] recurse(OrangeEcho echo, int[] message, int level)
	throws RemoteException
    {
	try {
	    String threadName = Thread.currentThread().getName();
	    display.appendText(name + " is at recursion level " +
	        level + ". message size = " + message.length + "\n");

		//threadName + ": " + toString() +
		//".recurse(message[" + message.length + "], " +
		//level + "): BEGIN\n");

	    int[] response;
	    if (level > 0)
		response = echo.recurse(this, message, level);
	    else {
		for (int i = 0; i < message.length; ++ i)
		    message[i] = ~message[i];
		response = message;
	    }

	    return response;
	} catch (RuntimeException e) {
	    synchronized (System.err) {
		System.err.print("OrangeImpl.recurse(): ");
		e.printStackTrace();
	    }
	    throw e;
	}
    }

    public String toString()
    {
	return name;
    }
}
