@echo off
if "%1"=="" goto no_java_home
set JAVA_HOME=%1
rem  This BAT script explains and carries out the process of compiling
rem  and running the Juicer.  
rem
rem  NOTE: The "call" command is used below to execute the other BAT
rem  script "rmic" so that it returns to this script upon
rem  completion.  The "call" is not be necessary when these commands
rem  are executed directly from the command prompt.

echo ************************************************************************
echo *
echo * This script goes through the complete process of compiling and
echo * running the Juicer on your local machine.
echo *
echo * (The AppleUserImpl server is bundled with its own registry, so there
echo * is no need to create one.)
echo *

set ORIGINAL_CLASSPATH=%CLASSPATH%
set ORIGINAL_PATH=%PATH%

@echo on
set PATH=%JAVA_HOME%\bin;%PATH%
set CLASSPATH=.;%JAVA_HOME%\lib\rmi.zip;%CLASSPATH%
@echo off

echo *
echo * Compile all Java sources files...
echo *
@echo on
javac *.java
@echo off

echo *
echo * Run rmic to generate stub and skeleton classes for Impl
echo * classes...
echo *
@echo on
call rmic AppleUserImpl AppleImpl AppletServer OrangeImpl OrangeEchoImpl
@echo off

echo *
echo * Start the server, AppleUserImpl...
echo *
@echo on
start java AppleUserImpl
@echo off


echo *
echo * Start java...
echo *
@echo on
java AppletServer
@echo off
goto end

:no_java_home
echo You must enter the path where java is installed as an argument to the batch file

:end
rem set CLASSPATH=%ORIGINAL_CLASSPATH%
rem set PATH=%ORIGINAL_PATH%
