#!/bin/sh -e

#
#Shell script to run the Juicer as an application
#


if [ $# -ne 1 ]
	then
	echo "Usage: run.sh <path to JDK>"
	exit 1
fi

JAVA_HOME=$1
PATH=$JAVA_HOME/bin:$PATH
export PATH
#LD_LIBRARY_PATH=$JAVA_HOME/lib/sparc"
#export LD_LIBRARY_PATH



#
# show some string (if -v, only in verbose)
#
show()
{
    if [ x"$1" = x"-v" ]; then
	    shift
	    echo "..." "$@"
    elif [ x"$1" = x"-c" ]; then
	shift
	echo ""
	echo "$@"
    else
	echo "$@"
    fi
}

#
# (There is no need to run rmiregistry for this example since
# the AppleUserImpl class bundles its own registry.)
#

CLASSPATH=.:$JAVA_HOME/lib/rmi.zip:$CLASSPATH
export CLASSPATH

show -v "CLASSPATH=$CLASSPATH"

#
# Compile the source
#
show -c "Compiling Java sources"
javac *.java

#
# Run rmic
#
show -c "Running rmic on the implementations"
rmic AppleUserImpl AppleImpl AppletServer OrangeImpl OrangeEchoImpl

#
# Running the server
#
show -c "Starting AppleUserImpl server"
java AppleUserImpl &
pid1=`echo $!`

# sleep to give the server time to start up and print its message
sleep 6

show -c "Starting the AppletServer as an application"
java AppletServer

kill $pid1






