/*
 * @(#)FileTest.java	1.8 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.awt.*;
import java.util.*;
import java.applet.*;
import java.io.*;

public class FileTest extends SecurityTest {
    public void test(Graphics g) throws java.io.IOException {
	 SecurityException se = null;
	 File f;
	 FileDescriptor fd;

	 f = new File("/etc/foo");

	 System.out.println("File.exists");
	 try {
	   f.exists();
	   se = null;
	 } catch (SecurityException e) {
		se = e;
	 }
	 if (se == null) {
	   throw new java.io.IOException("security failure");
	 }

	 System.out.println("File.canWrite");
	 try {
	   f.canWrite();
	   se = null;
	 } catch (SecurityException e) {
		se = e;
	 }
	 if (se == null) {
	   throw new java.io.IOException("security failure");
	 }

	 System.out.println("PrintStream.println");
	 try {
	   PrintStream ps = new PrintStream(new BufferedOutputStream(new FileOutputStream("/tmp/mrm"),128),true);
	   ps.println("look ma no hands - writing to /tmp/mrm from an applet");
	   se = null;
	 } catch (IOException ioe) {
	        System.out.println("Caught IO exception in FileTest, while doing PrintStream.println");
         } catch (SecurityException e) {
		se = e;
	 }
	 if (se == null) {
	   throw new java.io.IOException("security failure");
	 }

	 System.out.println("File.canRead");
	 try {
	   f.canRead();
	   se = null;
	 } catch (SecurityException e) {
		se = e;
	 }
	 if (se == null) {
	   throw new java.io.IOException("security failure");
	 }

	// Try to write the file /tmp/bar
	System.out.println("DataOutputStream.writeInt");
	 try {
	    String myFile = "/tmp/bar";
	    DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(myFile),128));
	    dos.writeInt(42);
	    System.out.println("Writing to " + myFile );
	    se = null;
	 } catch (SecurityException e) {
	    se = e;
	 }
	 if (se == null) {
	    throw new java.io.IOException("security failure - applet writes /tmp/bar");
	 }



	// Try to read the file ~/.hotjava/properties	
	 System.out.println("DataInputStream.readLine");
	 try {
	 String myFile = "~/.hotjava/properties";
	    DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(myFile),128));
	    System.out.println("First line of " + myFile + " is: " + dis.readLine());
	    se = null;
	 } catch (SecurityException e) {
	    se = e;
	 }
	 if (se == null) {
	    throw new java.io.IOException("security failure - applet read ~/.hotjava/properties");
	 }




	 System.out.println("File.isFile");
	 try {
	   f.isFile();
	   se = null;
	 } catch (SecurityException e) {
		se = e;
	 }
	 if (se == null) {
	   throw new java.io.IOException("security failure");
	 }
	 System.out.println("File.isDirectory");
	 try {
	   f.isDirectory();
	   se = null;
	 } catch (SecurityException e) {
		se = e;
	 }
	 if (se == null) {
	   throw new java.io.IOException("security failure");
	 }
	 System.out.println("File.lastModified");
	 try {
	   f.lastModified();
	   se = null;
	 } catch (SecurityException e) {
		se = e;
	 }
	 if (se == null) {
	   throw new java.io.IOException("security failure");
	 }
	 System.out.println("File.length");
	 try {
	   f.length();
	   se = null;
	 } catch (SecurityException e) {
		se = e;
	 }
	 if (se == null) {
	   throw new java.io.IOException("security failure");
	 }
	 System.out.println("File.mkdir");
	 try {
	   f.mkdir();
	   se = null;
	 } catch (SecurityException e) {
		se = e;
	 }
	 if (se == null) {
	   throw new java.io.IOException("security failure");
	 }
	 System.out.println("File.renameTo");
	 try {
	   f.renameTo(new File("/etc/bar"));
	 se = null;
	 } catch (SecurityException e) {
		se = e;
	 }
	 if (se == null) {
	   throw new java.io.IOException("security failure");
	 }
	 System.out.println("File.list");
	 try {
	   f.list();
	   se = null;
	 } catch (SecurityException e) {
		se = e;
	 }
	 if (se == null) {
	   throw new java.io.IOException("security failure");
	 }

	 FileInputStream fs;

	 System.out.println("new FileInputStream");
	 try {
	   fs = new FileInputStream("/etc/foo");
	   se = null;
	 } catch (SecurityException e) {
		se = e;
	 }
	 if (se == null) {
	   throw new java.io.IOException("security failure");
	 }
	 for (int i=0; i<64;i++) {
	   System.out.println("new FileInputStream " + i);
	   try {
	     fd = new FileDescriptor();
	     fs = new FileInputStream(fd);
	     se = null;
	   } catch (SecurityException e) {
	     se = e;
	   }
	   if (se == null) {
	     throw new java.io.IOException("security failure");
	   }
	}
	 RandomAccessFile raf;

	 try {
	   raf= new RandomAccessFile("/etc/foo", "r");
	   se = null;
	 } catch (SecurityException e) {
	   se = e;
	 }
	 if (se == null) {
	   throw new java.io.IOException("security failure");
	 }
	 try {
	   raf = new RandomAccessFile("/etc/foo", "rw");
	    se = null;
	 } catch (SecurityException e) {
		se = e;
	 }

// RandomAccessFile no longer has an int constructor,
// and it doesn't seem to have a constructor that takes a file descriptor either,
// so this test is obsolete 
//	 for (int i=0; i<64;i++) {
//	   try {
//	     raf = new RandomAccessFile(i, "r");
//	     se = null;
//	   } catch (SecurityException e) {
//	     se = e;
//	   }
//	   if (se == null) {
//	     throw new java.io.IOException("security failure");
//	   }
//       }
	 throw new SecurityException();
    }
}
	    
