/*
 * @(#)GetResourceTest.java	1.2 97/03/03 Marianne Mueller
 *
 * Copyright (c) 1995 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.awt.*;
import java.util.*;
import java.applet.*;
import java.io.*;
import java.net.URL;

public class GetResourceTest extends SecurityTest {

    public void test(Graphics g) {

      /**
       * Assertion: an applet should not be able to bypass the
       * restrictions on reading/writing a file on the client
       * side by using java.Class.getResourceAsStream
       * 
       * 	java.Class.getResourceAsStream(String name)
       * 	java.Class.getResource(String name)
       * 
       * These two methods are new to JDK1.1.   As of Nov 96, 
       * only the JavaBeans Development Kit and the JavaBeans spec
       * depends on these new features.   The intent is to allow
       * applets to access data that are used by classes that the
       * applet may access.  For example, 
       * 	images (for icons, animation, whatever)
       * 	audio (for audioclips)
       * 	localization strings
       * 	help data
       *
       * The 1st security test is:
       *	Try to read/write a file using these new methods
       *	Make sure this raises a security exception
       *	If it raises a security exception, the test passes
       * 
       * Additional tests needed ...
       * mrm 3 Mar 97
       */

      String str = "/home/mrm/images/bill_j3.gif";
      boolean caught = false;

      try {

	URL url = this.getClass().getResource(str);
	if (url == null) {
	  caught = true; 
	}
	else { 
	  Object obj = url.getContent();
	  g.drawImage((Image)obj, 0, 0, app);
	}
      } catch (Exception e) {
	e.printStackTrace();
      }

      if (caught) {
	throw new SecurityException("Caught security exception getting resource named: " + str);
      }
    }
}
