/*
 * @(#)ImageTest.java	1.3 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

/**
  *  Try to get an image from a 3rd host, using each of 
  *  the many different ways to get an image.
  *
  *	1 - use Applet.getImage(URL httpname)
  *	2 - use Applet.getImage(URL filename)
  *	3 - use sun.awt.Image.URLImageSource.createImage(String http_protocol)
  *	4 - use sun.awt.Image.FileImageSource.createImage(String file_protocol)
  *	5 - use sun.awt.Image.URLImageSource.createImage(URL url)
  *	6 - use sun.awt.Image.FileImageSource.createImage(String file_name)
  *
  * 
  *    These other tests are "ways to create images" that I jotted
  *    down in my notes, but which don't make sense to me right now.
  *        mrm 12/10/95
  *
  *	- construct an image producer, use component.getImage
  *	- construct an image producer, use toolkit.getImage
  *	- use toolkit.getImage(URL)
  *	- use toolkit.getImage(file)
  *
  *	This next one I don't think we can test at runtime anymore,
  *	since it should fail at compile time.  We need to come
  *	up with a set of "security related" tests that trigger compile
  *	time failures, for two reasons: compiler regression testing,
  *	and also, as a list of things we should check in the verifier
  *
  *	- try to get an image's ImageRepresentation 
  *  
  */

import java.applet.*;
import java.awt.*;
import sun.awt.image.URLImageSource;
import java.net.*;
import java.util.*;

public class ImageTest extends SecurityTest {
    Image img;
    String http_name = "http://www.catalog.com/mrm/backhoe_tiny.gif";
    String file_name = "file:///home/mrm/public_html/moi.gif";
    String local_file_name = "/home/mrm/images/moi/point-reyes.half";
    int caught = 0;

    public void test(Graphics g) {

      try { 
	System.out.println("--  1. ---");
        img = app.getImage(new URL(http_name));
        g.drawImage(img, 10, 10, app);
      } catch (MalformedURLException mfue) {
        System.out.println("Caught malformed URL exception");
      }	catch (SecurityException se) {
	caught++;
	se.printStackTrace();
/*	g.drawString("1. Applet.getImage(" + http_name + ") raised security exception",10,10);*/
      }

      try { 
	System.out.println("--  2. ---");
        img = app.getImage(new URL(file_name));
        g.drawImage(img, 10, 10, app);
      } catch (MalformedURLException mfue) {
        System.out.println("Caught malformed URL exception");
      }	catch (SecurityException se) {
	caught++;
	se.printStackTrace();
/*	g.drawString("2. Applet.getImage(" + file_name + ") raised security exception",10,30);*/
      }


      try { 
	System.out.println("--  3. ---");
        img = Toolkit.getDefaultToolkit().createImage(new sun.awt.image.URLImageSource(http_name));
        g.drawImage(img, 10, 10, app);
      } catch (MalformedURLException mfue) {
        System.out.println("Caught malformed URL exception");
      }	catch (SecurityException se) {
	caught++;
	se.printStackTrace();
/*	g.drawString("3. createImage.URLImageSource(" + http_name + ") raised security exception",10,50); */
      }



      try { 
	System.out.println("--  4. ---");
        img = Toolkit.getDefaultToolkit().createImage(new sun.awt.image.FileImageSource(file_name));
        g.drawImage(img, 10, 10, app);
      }	catch (SecurityException se) {
	caught++;
	se.printStackTrace();
/*	g.drawString("4. createImage.FileImageSource(" + file_name + ") raised security exception",10,70); */
      }


      try { 
	System.out.println("--  5. ---");
        img = Toolkit.getDefaultToolkit().createImage(new sun.awt.image.URLImageSource(new URL(http_name)));
        g.drawImage(img, 10, 10, app);
      } catch (MalformedURLException mfue) {
        System.out.println("Caught malformed URL exception");
      }	catch (SecurityException se) {
	caught++;
	se.printStackTrace();
/*	g.drawString("5. createImage.URLImageSource(new URL(" + http_name + ")) raised security exception",10,90);*/
      }



      try { 
	System.out.println("--  6. ---");
        img = Toolkit.getDefaultToolkit().createImage(new sun.awt.image.FileImageSource(local_file_name));
        g.drawImage(img, 10, 10, app);
      }	catch (SecurityException se) {
	caught++;
	se.printStackTrace();
/*	g.drawString("6. createImage.FileImageSource(" + local_file_name + ") raised security exception",10,110);*/
      }

	// If all 6 attempts raised security exception, indicate
	// to the test harness that we passed by throwing it a security
        // exception
	if (caught == 6) {
		throw new SecurityException("all 6 attempts to draw image from 3rd host raised SecurityException");
	} 
    }
}


