/*
 * @(#)OverflowTest.java	1.5 96/11/24
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.lang.*;
import java.awt.*;
import java.applet.*;
import java.io.PrintStream;

/**
 * Miscellaneous tests to stress system limits
 *
 *  1.  Try to overflow the stack by calling a method repeatedly.
 *      A stack overflow should happen, rather than the program crashing.
 *
 *  2.  Try to overflow the stack by tripping over an exception.
 *      A stack overflow should happen, rather than the program crashing.
 *  
 *  3.  Try to build a string that is too big for the runtime.
 *      An out of memory error should happen, rather than the program crashing.
 *
 *  4.  Try to crash AWT by asking it to paint that huge string
 *      See bugid 1225156 (this seems to be fixed in JDK-beta) - 
 *      AWT just draws the string silently. 
 */

public class OverflowTest extends SecurityTest {
    int count = 0;
    String s = "supercalifragilisticexpealidocious";
    String t; 	
    private boolean caught = false; 	
	
    public void test(Graphics g) throws java.io.IOException {

	// Overflow the stack in the simplest way possible
	recurse(); 
	if (caught == false) {
	    throw new java.io.IOException("security failure - didn't catch " + 
					  "StackOverflowError when too many " + 
					  "functions are on the stack");
	}

	// Overflow the stack by tripping over an exception 
	count = 0;
	caught = false;
	overFloat();
	if (caught == false) {
	    throw new java.io.IOException("security failure - didn't catch " +
					  "NumberFormatException when too many " + 
					  "floating point conversion functions " + 
					  "are on the stack");
	}

	// Overflow the stack by sending in an oversized string 
	count = 0;
	caught = false;
	oversizedString(s);
	if (caught == false) {
	    System.out.println("yo mama");
	    throw new java.io.IOException("security failure - didn't catch " + 
					  "OutOfMemoryError when creating an " +
					  "oversized string");
	}


	// Send in a string that is too big to paint()
	// If this test generates zillions of XErrors or other things that
	// might trigger X buffer overflows, investigate that. 
	overpaint(g, t);

	// We made it through all the tests, so throw a SecurityException
	// to celebrate!   that is, inform the test harness that we passed
	// the tests, by throwing it a SecurityException. 
	throw new SecurityException();
    }

    public void recurse() {
	try {
	    count++;
	    recurse();
        } catch (StackOverflowError e) {
	    System.out.println("caught StackOverflowError after " + count + 
			       " method invocations");
	    caught = true;
	}
    }


    public void overFloat() {
	try {
	    count++;
	    Float.valueOf("overFloat");
        }
	catch (NumberFormatException e){
	    try { 
		overFloat();
	    } 
	    catch (StackOverflowError f) {
		System.out.println("caught NumberFormatException after " + count +
				   " calls");
		caught = true;
	    }
	}
    }


    public void oversizedString(String s){
	int i = 0;
	
	// Get started - stuff the input string into t 
	t = s;

	// Construct a string that is too big
	try {

	    //  Quickly build up a big-ish string 
	    for(i=0; i<20; i++) {
		t = t.concat(t);
		System.out.println("concat " + i);
	    }
	    // then push it over the edge 
	    for(i=0; i<17; i++) {
		t = t.concat("Z");
		count++;
	    }
	} catch (OutOfMemoryError e) {
	    System.out.println("Sorry Charlie out of memory when t is length " + 
			       t.length());
	    caught = true;
	}
	System.out.println("Length of t is " + t.length() + " after " + count + 
			   " extra concats");
    }


    public void overpaint(Graphics g, String s){
	try {
	    g.drawString(s,10,10);
	} catch (Exception e) {
	    System.out.println("Caught Exception in overpaint()");
	} catch (Error error) {
	    System.out.println("Caught Error in overpaint()");
	}
    }

}

