/*
 * @(#)PropertiesTest.java	1.5 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.awt.*;
import java.util.*;
import java.applet.*;

public class PropertiesTest extends SecurityTest {
    public void test(Graphics g) throws java.io.IOException {
	SecurityException se = null;

	// the next two tests should raise SecurityException

	try {
	    Properties props = System.getProperties();
	    throw new java.io.IOException("security failure");
	} catch (SecurityException e) {
	    se = e;
	}
	try {
	    System.setProperties(new Properties());
	    throw new java.io.IOException("security failure");
	} catch (SecurityException e) {
	    se = e;
	}


	// the next 5 tests should raise SecurityException.  If they don't,
	// raise IOException as an indication that security failed

	// 1. try to read java.home
	try {
	    System.out.println("Java installation directory :" + System.getProperty("java.home"));
	    throw new java.io.IOException("security failure on reading java.home property");
	} catch (SecurityException e) {
	    se = e;
	    System.out.println("Caught security exception while trying to read java.home ");
	}



	// 2. try to read java.class.path
	try {
	    System.out.println("Java classpath :" + System.getProperty("java.class.path"));
	    throw new java.io.IOException("security failure on reading java.class.path property");
	} catch (SecurityException e) {
	    se = e;
	    System.out.println("Caught security exception while trying to read java.class.path ");
	}



	// 3.  try to read user.name
	try {
	    System.out.println("User account name: " + System.getProperty("user.name"));
	    throw new java.io.IOException("security failure on reading user.name property");
	} catch (SecurityException e) {
	    se = e;
	    System.out.println("Caught security exception while trying to read user.name ");
	}



	// 4.  try to read user.home
	try {
	    System.out.println("User's home directory: " + System.getProperty("user.home"));
	    throw new java.io.IOException("security failure on reading user.home property");
	} catch (SecurityException e) {
	    se = e;
	    System.out.println("Caught security exception while trying to read user.home ");
	}



	// 5.  try to read user.dir
	try {
	    System.out.println("User's current working directory: " + System.getProperty("user.dir"));
	    throw new java.io.IOException("security failure on reading user.dir property");
	} catch (SecurityException e) {
	    se = e;
	    System.out.println("Caught security exception while trying to read user.dir ");
	}


	// these next 10 tests should not raise SecurityException,
	// unless the system property has been turned off in the
	// user's property setup
	try {
	    System.out.println("Java version number:" + System.getProperty("java.version"));
	    System.out.println("Java vendor specific string:" + System.getProperty("java.vendor"));
	    System.out.println("Java vendor URL :" + System.getProperty("java.vendor.url"));
	    System.out.println("Java class version number:" + System.getProperty("java.class.version"));
	    System.out.println("Operating system name :" + System.getProperty("os.name"));
	    System.out.println("Operating system architecture :" + System.getProperty("os.arch"));
	    System.out.println("Operating system version :" + System.getProperty("os.version"));
	    System.out.println("File separator :" + System.getProperty("file.separator"));
	    System.out.println("Path separator :" + System.getProperty("path.separator"));
	    System.out.println("Line separator :" + System.getProperty("line.separator"));
	} catch (SecurityException e) {
	    se = e;
	}


	
	if (se != null) {
	    throw se;
	}
    }
}

