/*
 * @(#)SecurityTest.java	1.9 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.awt.*;
import java.util.*;
import java.applet.*;

public abstract class SecurityTest {
    SecurityTestApplet app;
    Font	   appFont;
    protected String name;
    int sWidth = 0;
    int sHeight = 0;
    final int PASSED = 0;
    final int FAILED = 1;
    int status = FAILED;

    public void init(SecurityTestApplet app) {
	this.app = app;
	this.name = getClass().getName();
	appFont = new Font("Helvetica", Font.BOLD, 14);
    }

    public void drawCenteredString(String s,
				   Color color,
				   Graphics g,
				   Dimension r) {
	FontMetrics fm = g.getFontMetrics();
	sWidth = fm.stringWidth(s);
	sHeight = fm.getHeight();
	g.setColor(color);
	g.drawString(s, (r.width - sWidth)/2, (r.height - sHeight)/2);
    }
    public void paint(Graphics g) {
        int appWidth = app.size().width;
        int appHeight = app.size().height;

        drawCenteredString(name, Color.black, g, app.size());
        app.printString(this.toString());
	try {
	    test(g);
	    switch(this.getStatus()) {
	    case PASSED:
	      app.testPassed(this);
	      g.drawString("- PASSED", appWidth/2 + sWidth, (appHeight - sHeight)/2);
	      return;
	    case FAILED:
	      app.testFailed(this, null);
	      g.drawString("- FAILED", appWidth/2 + sWidth, (appHeight - sHeight)/2);
	      return;
	    }
	} catch (SecurityException e) {
	    app.testPassed(this);
	    g.drawString("- PASSED", appWidth/2 + sWidth, (appHeight - sHeight)/2);
	    return;
	} catch (Exception e) {
	    app.testFailed(this, e);
	    g.drawString("- FAILED", appWidth/2 + sWidth, (appHeight - sHeight)/2);
	    return;
	} catch (Error e) {
	    app.testFailed(this, e);
	    g.drawString("- FAILED", appWidth/2 + sWidth, (appHeight - sHeight)/2);
	    return;
	}  catch (Throwable t) {
	    app.testFailed(this, t);
	    g.drawString("- FAILED", appWidth/2 + sWidth, (appHeight - sHeight)/2);
	    return;
	}
	app.testFailed(this, null);
	g.drawString("- FAILED", appWidth/2 + sWidth, (appHeight - sHeight)/2);
    }

    public String toString() {
	return "### " + name;
    }
    protected abstract void test(Graphics g) throws Exception;

    public int getStatus() {
      return status;
    }
}
