/*
 * @(#)SecurityTestApplet.java	1.12 96/11/24
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.awt.*;
import java.util.*;
import java.applet.*;

public class SecurityTestApplet extends Applet implements Runnable {
    Thread	tester;
    Vector	tests;
    int		currentTest = -1;
    int		failed = 0;

    synchronized void printString(String s) {
	System.out.println(s);
    }

    synchronized void testPassed(SecurityTest t) {
	System.out.println(t + " PASSED");
    }

    synchronized void testFailed(SecurityTest t, Throwable th) {
	if (th != null) {
	    System.out.println(t + " FAILED because of " + th);
	    System.out.println("stack trace: ");
	    System.out.flush();
	    th.printStackTrace();

	} else {
	    System.out.println(t + " FAILED");
	}
	failed++;
    }

    public void init() {
	tester = new Thread(this);
	tests = new Vector();
	String arg = getParameter("ntests");
	int nTests = 0;

	if (arg != null) {
	    nTests = Integer.valueOf(arg).intValue();
	}
	for (int i=1; i <= nTests; i++) {
	    String testName = getParameter("test" + i);
	    if (testName != null) {
		try {
		    SecurityTest test = 
			(SecurityTest)Class.forName(testName).newInstance();
		    test.init(this);
		    tests.addElement(test);
		} catch (Exception e) {
		    System.out.println("failed to load " + testName);
		    e.printStackTrace();
		}
	    }
	}
    }

    public void start() {
	printString("** SecurityTest starting **");
	if (tester.isAlive()) {
	    tester.resume();
	} else {
	    tester.start();
	}
    }
    public void stop() {
	printString("** SecurityTest suspended **");
	tester.suspend();
    }
    public void destroy() {
	printString("** SecurityTest stop **");
	tester.stop();
    }
    public synchronized void paint(Graphics g) {
	if (currentTest != -1 && currentTest < tests.size()) {
	    SecurityTest s = (SecurityTest)(tests.elementAt(currentTest));
	    s.paint(g);
	    currentTest++;
	} else {   	/* Display results of test */
	  if (failed == 0) {
	    g.drawString("** SecurityTest done (all tests passed) **", 20, 20);
	  } else {
	    g.drawString("** SecurityTest done (" + failed + " tests failed) **",
			 20, 20);
	    }
	}
	notify();
    }
    public synchronized void waitForPaint() {
	try {
	    wait();
	} catch (InterruptedException e) {
	    return;
	}
    }
    public void run() {
	try {
	  /* Note that we repaint once after the last test so
	     that the results will be displayed */
	    for (currentTest=0; currentTest <= tests.size();) {
		repaint();
		waitForPaint();
		Thread.sleep(2000);
	    }
	    if (failed == 0) {
		printString("** SecurityTest done (all tests passed) **");
		System.err.println("** SecurityTest done (all tests passed) **");
	    } else {
		printString("** SecurityTest done (" + failed + " tests failed) **");
		System.err.println("** SecurityTest done (" + failed + 
				   " tests failed) **");
	    }
	} catch (InterruptedException e) {
	}
    }
}



