/*
 * @(#)ClassLoaderFinalizerTest.java	1.2 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import sun.applet.AppletClassLoader;

import java.io.FileInputStream;
import java.util.*;
import java.io.*;
import java.net.*;

public class ClassLoaderFinalizerTest extends java.applet.Applet {

    EvilClassLoader ecl = null;

    public void init() {
	try {
	    EvilClassLoader ecl = new EvilClassLoader();
	} catch (sun.applet.AppletSecurityException e) {
	    System.out.println("Failed to create a subclass of ClassLoader: " + ecl);
	}
	System.gc();
    }
}

class EvilClassLoader extends ClassLoader {

    public Class loadClass(String s, boolean a){
	return null;
    }

    public void finalize() {
	Class stringClass = null;
	System.out.print("\n\n\nWARNING: Executing finalization\n");
	try {
	    System.out.print("Trying to define a class...\n");
	    defineClass(new byte[1], 0, 1);
	    System.out.println("SUCCEEDED at defining define a class...\n");
	} catch (sun.applet.AppletSecurityException e) {
	    System.out.println("FAILED to define define a class...\n");
	} catch (Throwable t) {
	    // This will get a class format exception. It should be replaced
	    // with something reasonable.
	    System.out.println("Threw " + t);
	}
	try {
	    System.out.print("Trying to find system class java.lang.String...\n");
	    stringClass = findSystemClass("java.lang.String");
	    System.out.println("SUCCEEDED and found system class...: " +
			       stringClass + "\n");
	} catch (ClassNotFoundException e) {
	    System.out.println("Failed to find class java.lang.String...\n");
	} catch (sun.applet.AppletSecurityException e) {
	    System.out.println("FAILED to find class java.lang.String...\n");
	}
	try {
	    System.out.print("Trying to resolve class java.lang.String...\n");
	    resolveClass(stringClass);
	    System.out.println("SUCCEEDED at resolving a class...\n");
	} catch (sun.applet.AppletSecurityException e) {
	    System.out.println("FAILED to resolve a class...\n");
	}
	System.out.print("Done with finalization\n");
    }
}

