/*
 * @(#)getLocalHostTest.java	1.2 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
/*
 * File: getLocalHostTest.java
 * Comment: THis file checks the output of InetAddress.getLocalHost() to be
 * 127.0.0.0. This modification was made so as not to reveal the hostname of
 * the machine on which the applet is running.
 *
 * @(#)author:  Vijay Srinivasan
 * @(#)version: 1.2
 * @(#)date:    98/04/16
 */

import java.applet.Applet;
import java.awt.Graphics;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class getLocalHostTest extends SecurityTest {
  public void test(Graphics g) {
    String inet, hostname, IPaddress;
    int separatorpt;

    try {
      inet = InetAddress.getLocalHost().toString();
      separatorpt = inet.indexOf('/');
      if (separatorpt == -1) {
	status = FAILED;
	return;
      }

      hostname = inet.substring(0, separatorpt);
      IPaddress = inet.substring(separatorpt+1);

      status = (hostname.equals("localhost")) ? PASSED : FAILED;
      status = (IPaddress.equals("127.0.0.1")) ? status : FAILED;
    } catch (UnknownHostException e) {
      e.printStackTrace();
      status = FAILED;
    }
  }
}
