/*
 * @(#)TestAcl.java	1.3 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.io.*;
import java.util.*;
import java.security.Principal;
import java.security.acl.*;
import sun.security.acl.*;

public class TestAcl {

    private Principal admin = new PrincipalImpl("admin");

    public static void main(String[] args) {
	TestAcl ta = new TestAcl();
	ta.execute("test1.acl", "CAB");
	ta.execute("test2.acl", "CB");
	ta.execute("test3.acl", "CB");
	ta.execute("test4.acl", "B");
    }
    
    public void execute(String fileName, String result) {
	try {
	    FileInputStream fin = new FileInputStream(fileName);
	    Properties tmpProperties = new Properties();
	    tmpProperties = loadAclProperties(fin);
	    fin.close();
	    AclImpl acl = parseAclProperties(tmpProperties);
	    System.out.println(acl.toString());

	    StringBuffer sb = new StringBuffer();
	    Enumeration e = acl.getPermissions(admin);
	    while (e.hasMoreElements()) {
		Permission perm = (Permission) e.nextElement();
		sb.append(perm.toString());
	    }
	    
	    if (sb.toString().equals(result))
		System.out.println("Test " + fileName + " succeeded");
	    else
		System.out.println("Test " + fileName + " failed");		

	    System.out.println();

	} catch (IOException e) {
	    e.printStackTrace();
	    System.out.println("Test " + fileName + " failed");		
	}
    }


    private Properties loadAclProperties(InputStream in) 
	throws IOException
    {
	DataInputStream ds = new DataInputStream(in);
	String line;
	Properties p = new Properties();
	
	while ( (line = ds.readLine()) != null) {
	    StringTokenizer st = new StringTokenizer(line, "=");
	    if (!st.hasMoreTokens())
		continue;
	    String lhs = st.nextToken();
	    String rhs = (String) p.get(lhs);
	    if (rhs == null) 
		rhs = st.nextToken();
	    else
		rhs = rhs + "," + st.nextToken();

	    p.put(lhs, rhs);
	}

	return p;
    }

    private AclImpl parseAclProperties(Properties p)
	throws IOException
    {
	String allowedHosts = null;
	Enumeration e;

	AclImpl acl = new AclImpl(admin, "acl");
	e = p.propertyNames();

	while(e.hasMoreElements()) {
	    AclEntry aclEntry = null;
	    String lhs = (String) e.nextElement();
	    String rhs = (String) p.get(lhs);
	    rhs = rhs.trim();

	    String principal = null;
	    String attribute = null;
	    String perms = rhs;
	    StringTokenizer st = new StringTokenizer(lhs, ".");

	    if (st.hasMoreTokens()) 
		attribute = st.nextToken();

	    if (st.hasMoreTokens())
		principal = st.nextToken();

	    if (principal == null || perms == null) 
		return null;

	    
	    aclEntry = getAclEntry(attribute, principal);

	    st = new StringTokenizer(perms, ",");
	    while (st.hasMoreTokens()) {
		Permission permission;
		String permString = (String) st.nextToken();
		permission = new PermissionImpl(permString);
		aclEntry.addPermission(permission);
		try {
		    acl.addEntry(admin, aclEntry);
		} catch(NotOwnerException pe) {}
	    }
	}
	return acl;
    }

    private AclEntry getAclEntry(String attribute, String principal)
	throws IOException
    {
	boolean negative = false;
	AclEntry aclEntry = null;
	Group g = null;

	if (attribute.startsWith("-")) 
	    negative = true;

	if (attribute.startsWith("Group", 1) || attribute.startsWith("Group")) {
	    g = new GroupImpl(principal);
	    g.addMember(admin);
	    aclEntry = new AclEntryImpl(g);
	} else if (attribute.startsWith("User", 1) || attribute.startsWith("User")) {
	    aclEntry = new AclEntryImpl(admin);
	} 

	if (negative) 
	    aclEntry.setNegativePermissions();

	return aclEntry;
    }


}



