package crypto;

import java.security.*;
import test.*;

public class DigestCloneTest extends Test {
    
    public String algorithm;
    public String provider;

    public void run() throws TestException {

	try {
	    byte[] data = new byte[1000];
	    byte[] dataDigest, dataDigestRef;

	    for (int i = 0; i < 1000; i++) {
		data[i] = (byte)i;

	    }

	    /* In this we create dig1, we update dig1 with data once */
	    MessageDigest dig1 = MessageDigest.getInstance(algorithm,provider);
	    dig1.update(data);

	    MessageDigest dig2 = (MessageDigest)dig1.clone();

	    /* This should not affect dig2 */
	    dig1.update(data);
	    dig1.digest();

	    /* dig2 should be a digest of data once, while dig1 a digest of
	       data twice. */
	    dataDigest = dig2.digest();

	    /* For reference, we check with another, state-free digest */
	    MessageDigest dig2ref = MessageDigest.getInstance(algorithm, provider);
	    dig2ref.update(data);
	    dataDigestRef = dig2ref.digest();

	    if (!MessageDigest.isEqual(dataDigest, dataDigestRef)) {
		throw new TestException("digests don't match");
	    } else {
		System.out.println("digests do match.");
	    }
	} catch (Exception e) {
	    throw new TestException("error in clone test for " + algorithm +
				    " from " + provider, e);
	}
    }
}
	    
	    
	    
	    
	    
	    
	    
    
