/*
 * 97/01/26, @(#)GenerateDigestTest.java	1.3
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

package crypto;

import java.io.*;
import java.util.*;
import java.security.*;

import test.*;

/**
 * This program generates random test data for testing message
 * digests. It generates a file containing sample bit strings and
 * their alledged digest. The data format is:
 *
 * <pre>
 * datalength 
 * data
 * digestlength
 * digest
 * </pre>
 *
 * <p>The length are bytes, and represent the number of bytes of the
 * following quantity.
 *
 * <p>The arguments to the program are: (arguments in bold are
 * required) <ul>
 *
 * <li><b>fileout</b>: the file to which to output the data.
 *
 * <li><b>sample/length</b>: the number of samples to generate for
 * each length range.
 *
 * <li><b>algorithm</b>: which digest algorith to use.
 *
 * <li><b>provider</b>: which provider to use.
 *
 * <li>from_length and to_length: the length range for the data to
 * generate (i.e. from 1 to 20 bytes).
 *
 * </ul>
 *
 * @see VerDigestData
 *
 * @version     1.2 96/12/11
 * @author Benjamin Renaud */
public class GenerateDigestTest extends Test {

    public File output;

    public String provider;
    public String algorithm;
    
    public int times = 25;
    public int min = 10;
    public int max = 50;

    public void run() throws TestException {
	
	try {

	    /* Flip between using the byte-at-a-time API and the
	     * bulk API */
	    boolean flip = true;
	    MessageDigest md = MessageDigest.getInstance(algorithm, provider);
	    FileOutputStream fos = new FileOutputStream(output);
	    
	    Random rnd = new Random();
	    for (int len = min; len < max + 1; len++) {
		for (int t = 0; t < times; t++) {
		
		    byte[] data = new byte[len];
		    for (int i = 0; i < len; i++) {
			if (rnd != null) {
			    data[i] = (byte)rnd.nextInt();
			} else {
			    data[i] = (byte)i;
			}
		    }
		    
		    if (flip) {
			for (int i = 0; i < data.length; i++) {
			    md.update(data[i]);
			}
			flip = false;

		    } else {
			md.update(data);
			flip = true;
		    }

		    byte[] digest = md.digest();
		
		    fos.write(data.length);
		    fos.write(data);
		    fos.write(digest.length);
		    fos.write(digest);
		}
	    }
	    System.out.println("Generated and hashed " + times + 
			       " byte string, ranging from " + min + 
			       " to " + max + " bytes in length.");
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }
}
		



	    
