/*
 * 97/01/27, @(#)SimpleSignatureTest.java	1.6
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

package crypto;

import java.io.*;
import java.util.*;
import java.security.*;
import java.security.interfaces.*;

import test.*;

/**
 */
public class SimpleSignatureTest extends Test {
    
    public String algorithm;
    public String provider;

    public void run() throws TestException {
	
	try {
	    KeyPairGenerator gen = 
		KeyPairGenerator.getInstance(algorithm, provider);
	    
	    gen.initialize(1024, new SecureRandom());
	    KeyPair pair = gen.generateKeyPair();
	    PublicKey pub = pair.getPublic();
	    PrivateKey priv = pair.getPrivate();

	    byte[] data = new byte[1000];
	    for (int i = 0; i < 1000; i++) {
		data[i] = (byte)i;
	    }

	    Signature signer = Signature.getInstance(algorithm, provider);
	    signer.initSign(priv);
	    signer.update(data);
	    byte[] signature = signer.sign();

	    Signature verifier = Signature.getInstance(algorithm, provider);
	    verifier.initVerify(pub);
	    verifier.update(data);
	    boolean verifies = verifier.verify(signature);

	    System.out.println("public: " + pub + "\n");
	    System.out.println("private: " + priv + "\n");
	    System.out.println("verifies: " + verifies);

	} catch (Exception e) {
	    throw new TestException("unexpected exception", e);
	}
    }
}
		



	    
