/*
 * 97/01/26, @(#)VerifyDigestTest.java	1.4
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

package crypto;

import java.io.*;
import java.util.*;
import java.security.*;

import test.*;

/**
 * This program verifies test data for a message digest. It reads the data in
 * the format generated by GenDigestData:
 * 
 * <pre>
 * datalength 
 * data
 * digestlength
 * digest
 * </pre>
 *
 * <p>and verifies it against a specific implementation.
 *
 * <p>The length are bytes, and represent the number of bytes of the
 * following quantity.  
 *
 * @see GenDigestData
 */
public class VerifyDigestTest extends Test {

    public File input; // dataFile;
    public String algorithm;
    public String provider;
    
    boolean bulk=false;

    int total = 0;

    public void run() throws TestException {
	
	//	File input = new File(dataFile);
	try {
	    boolean bulk = true;
	    int[] failures = new int[100];
	    
	    if (!input.exists()) {
		throw new TestException("file " + input + " not found.");
	    }
	    
	    MessageDigest md = MessageDigest.getInstance(algorithm, provider);
	    FileInputStream fis = new FileInputStream(input);

	    int dataLength = fis.read();
		
	    while(dataLength != -1) {
		byte[] data = new byte[dataLength];

		if (bulk) {
		    int read = fis.read(data);

		    if (read != dataLength) {
			throw new TestException("short data read: " + 
						dataLength);
		    }
		    md.update(data);

		} else {
		    for (int i = 0; i < dataLength; i++) {
			md.update((byte)fis.read());
		    }
		}
		
		int digestLength = fis.read();
		byte[] digest = new byte[digestLength];
		int read = fis.read(digest);

		if (read != digestLength) {
		    throw new TestException("short digest read: " + 
					    digestLength);
		}
		
		byte[] computedDigest = md.digest();
		
		if (!MessageDigest.isEqual(computedDigest, digest)) {
		    failures[dataLength] += 1;
		}
		dataLength = fis.read();
		total++;
	    }

	    int totalF = 0;

	    for (int i = 0; i < 100; i++) {
		int f = failures[i];
		totalF += f;
	    }
	    if (totalF != 0) {
		throw new TestFailureException("FAILED: " + totalF);

	    } else {
		System.out.println("verified " + total + " hashes.");
	    }

	} catch (Exception e) {
	    throw new TestException("unexpected exception", e);
	}
    }
}
		



	    
