/*
 * @(#)TestParsePKCS7.java	1.1 96/12/12
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
package pkcs;

import java.io.*;
import java.security.*;

import sun.security.pkcs.*;
import sun.security.util.*;

import tests.Test;

public class TestParsePKCS7 extends Test {

    public File input;

    public void run() {

	if (!input.exists()) {
	    System.err.println("cannot find file: " + input);
	}

	try {
	    FileInputStream fis = new FileInputStream(input);
	    DataInputStream dis = new DataInputStream(fis);
	    byte[] data = new byte[dis.available()];
	    dis.readFully(data);
	    
	    PKCS7 pkcs = new PKCS7(new DerInputStream(data));
	    
	    System.out.println("success:\n" + pkcs);

	} catch (Exception e) {
	    e.printStackTrace();
	}
    }
}
    
