/*
 * 97/01/26, @(#)Test.java	1.7
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

package test;

import java.lang.reflect.*;
import java.io.*;
import java.util.*;

/**
 * This class defines is a lightweight general purpose test
 * class. See the README file for more info.
 *
 * @author Benjamin Renaud
 */
public abstract class Test {

    private static boolean verbose = true;

    public static Test getTest(String name) throws NoSuchTestException {
	
	try {
	    Class cl = Class.forName(name);
	    Object inst = cl.newInstance();
	    
	    if (inst instanceof Test) {
		Test test = (Test)inst;
		
		return test;

	    } else {
		throw new NoSuchTestException("class " + name + 
					      " not a test.");
	    }
	} catch (Exception e) {
	    throw new NoSuchTestException("error making test " + name, e);
	}
    }

    public abstract void run() throws TestException;

    public static void testRun(String filename) {

	Vector tests = new Vector();
	File propFile = new File(filename);

	if (propFile.exists()) {
	    try {
		InputStream fis = new FileInputStream(propFile);
		DataInputStream dis = new DataInputStream(fis);
		while (dis.available() != 0) {
		    String test = dis.readLine();
		    if (!test.equals("")) {
			tests.addElement(test);
		    }
		}
		testRun(tests);
		fis.close();

	    } catch (IOException e) {
		System.err.println("IOError running test " + propFile);
		e.printStackTrace();
	    }

	} else {
	    System.err.println("test file " + propFile + " not found. " +
			       "test not run.");
	}
    }
	
    private static String getArgs(String prop) {
	int start = prop.indexOf('=') + 1;
	if (start == 0) {
	    return null;
	}
	int end = prop.length();
	return prop.substring(start, end);
    }

    private static String getName(String prop) {
	int end = prop.indexOf('=');
	if (end == -1) {
	    end = prop.length();
	}
	return prop.substring(0, end);
    }

    public static void testRun(Vector testVector) {
	Enumeration tests = testVector.elements();
	
	while (tests.hasMoreElements()) {
	    String test = (String)tests.nextElement();
	    String testName = getName(test);
	    String testArgs = getArgs(test);

	    try {
		
		if (testName.equals("test.run")) {
		    testRun(testArgs);

		} else {
		
		    Test testInstance = getTest(testName);
		    if (testArgs != null) {
			System.err.println("test args: " + testArgs);

			StringTokenizer st = new StringTokenizer(testArgs,",");
		
			int i = 0;
			while (st.hasMoreTokens()) {
			    String arg = st.nextToken();
			    int eqi = arg.indexOf('=');
			    String fieldName = arg.substring(0, eqi);
			    String value = arg.substring(eqi + 1, 
							 arg.length());

			    testInstance.setArg(fieldName, value);
			}
		    }
		
		    testInstance.run();
		}

	    } catch (NoSuchTestException e) {
		/* Cannot run the test: error getting it */
		if (verbose) {
		    e.printStackTrace();
		}
		System.err.println(e.toString());
		
	    } catch (IllegalArgumentException e) {
		/* Cannot run the test: invalid argument */
		if (verbose) {
		    e.printStackTrace();
		}
		System.err.println(e.toString());

	    } catch (TestException e) {
		if (verbose) {
		    e.printStackTrace();

		} 
		System.err.println("Error running test: " + testName + 
				   ": " + e.getMessage());
	    }
	}
    }

    void setArg(String name, String value) throws IllegalArgumentException {
	Class c = this.getClass();

	Field f;
	try {
	    f = c.getDeclaredField(name);
	}
	catch (NoSuchFieldException x) {
	    throw new IllegalArgumentException("Invalid argument name: " + 
					       name);
	}
	Class ft = f.getType();

	try {
	    if (ft == Integer.TYPE) {
		int n = Integer.parseInt(value);
		f.setInt(this, n);

	    } else if (ft == Class.forName("java.io.File")) {
		f.set(this, new File(value));

	    } else if (ft == name.getClass()) {
		f.set(this, value);
	    }

	} catch (Exception x) {
	    throw new IllegalArgumentException("Invalid argument: " + name +
					       "=" + value + " (" + 
					       x.toString() + "). Class: " + 
					       ft);
	}
    }


    public static void main(String[] args) {
	int tr = 0;

	if (args.length == 0) {
	    System.err.println("usage: test <testfile1> <testfile2> ...");
	    System.exit(1);
	}
	
	if (args[0].startsWith("-")) {
	    tr++;
	    int i = 0;
	    while (++i < args[0].length()) {

		switch((int)args[0].charAt(i)) {
		    
		case 'q':
		    verbose = false;
		    break;
		default:
		    break;
		}
	    }
	}	    

	for (; tr < args.length; tr++) {
	    testRun(args[tr]);
	}
    }
}

class NoSuchTestException extends TestException {

    NoSuchTestException(String msg) {
	super(msg);
    }

    NoSuchTestException(String msg, Throwable t) {
	super(msg, t);
    }
}
