/*
 * @(#)CertGen.java	1.7 97/01/21
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

// package sun.security.x509.tests;

import java.io.*;
import sun.security.x509.*;


/**
 * This is a class used to test the X.509 cert generation code.
 */
public class CertGen {

    // Usage:  CertGen sig-algorithm
    //	... sig-algorithm = "MD5withRSA", "MD2withRSA", "DSA"
    public static void main (String argv [])
    {
	X500Name	subject;
	CertAndKeyGen	keypair;
	X509Cert	x1, x2;
	byte		cert [];

	if (argv.length != 1) {
	    System.out.println ("usage:  CertGen [MD5withRSA|MD2withRSA|DSA]");
	    System.exit (1);
	}

	try {
	    subject = new X500Name ("Zaphod Beeblebrox",
		    "Transgalactic Inc.", "Ursa Major", "US");

	    keypair = new CertAndKeyGen (argv [0], argv[0]);
	    keypair.generate (1024);
	    x1 = keypair.getSelfCert (subject,
		60	// seconds per minute
		* 60	// minutes per hour
		* 24	// hours per day
		* 30	// days per month (more or less)
		* 6	// months
		);
	    cert = x1.getSignedCert ();
	    x2 = new X509Cert (cert);

	    System.out.println ("Generated Cert:  " + x2);

	    x1.verify (keypair.getPublicKey ());
	    x2.verify (keypair.getPublicKey ());

	    if (!x1.equals (x2)) {
		System.out.println ("?? x1 != x2 ??");
		System.out.println (" !!  TEST FAILED !! ");
		System.exit (1);
	    }

	} catch (Exception e) {
	    System.out.println ("Exception:  " + e);
	    e.printStackTrace ();
	    System.out.println (" !!  TEST FAILED !! ");
	    System.exit (1);
	}

	System.out.println ("PASS:  Constructed and verified a "
	    + "self-signed X.509 Cert, using '" + argv [0] + "'");
	System.out.println ();
    }
}
