/*
 * @(#)CertParse.java	1.6 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

// package sun.security.x509.tests;

import java.io.*;
import java.security.*;
import sun.security.x509.X500Name;
import sun.security.x509.X509Cert;
import sun.security.x509.CertException;


/**
 * This is a class used to test X.509 cert parsing and validation.
 * It works on cert changes as well as individual certs.
 */
public class CertParse
{

    private static void error (boolean allowable)
    {
	if (!allowable) {
	    System.out.println (" !!  TEST FAILED !! ");
	    System.exit (1);
	}
    }

    /*
     * CertParse cert1 [cert2 cert3 ... ] pass
     *		The test should pass.  The last cert is self-signed,
     *		and it's the "root CA" in a cert chain starting at
     *		the first cert.
     *
     * CertParse cert1 [cert2 cert3 ... ] fail
     *		As above, but the test should fail.  Perhaps one
     *		of the certs in the chain is invalid, or the chain
     *		is incomplete.
     */
    public static void main (String argv []) {
	boolean		isNegative = false;
	int		i;
	PublicKey	key = null;
	X500Name	issuer = null;

	if (argv.length < 2) {
	    System.out.println (
		"usage:  CertParse cert [cert ...] pass|fail");
	    error (false);
	}
	if (argv [argv.length - 1].equalsIgnoreCase ("fail"))
	    isNegative = true;

	//
	// Process certs starting at root CA.
	//
	for (i = argv.length - 2; !(i < 0); i--) {
	    String certFile = argv [i];
	    
	    byte		certdata [] = null;

	    try {
		//
		// Read the cert in from the file.
		//
		{
		    InputStream	is;
		    int		len;

		    is = new FileInputStream (certFile);
		    len = is.available ();
		    certdata = new byte [len];

		    if (is.read (certdata) != len) {
			System.out.println ("** short read of cert");
			error (isNegative);
			continue;
		    }

		    is.close ();
		}


		//
		// Parse and print the cert
		//
		X509Cert	cert = new X509Cert (certdata);

		System.out.println ("-----------------------");
		System.out.println ("Cert File = " + certFile);
		System.out.println (cert);

		//
		// Bootstrap chain processing (topmost cert in chain).
		//
		if (key == null) {
		    key = cert.getPublicKey ();
		    issuer = cert.getSubjectName ();
		}

		//
		// Validate the cert, recognizing expired ones.
		//
		try {
		    if (!cert.getIssuerName ().equals (issuer)) {
			System.out.println ("Cert Issuer Mismatch:  "
				+ cert.getIssuerName () + " expected, got "
				+ issuer);
			error (isNegative);
			continue;
		    }
		    cert.verify (key);
		    System.out.println ("  ++ Cert verified");

		    //
		    // Set up for next cert in chain
		    //
		    key = cert.getPublicKey ();
		    issuer = cert.getSubjectName ();

		} catch (CertException e) {
		    if (e.getVerfCode ()
			    == CertException.verf_INVALID_EXPIRED)
			System.out.println ("  -- Cert expired");
		    else {
			System.out.println ("  -- Cert doesn't verify!");
			e.printStackTrace ();
		    }
		    error (isNegative);

		} catch (Exception e) {
		    System.out.println ("  -- Error during verify!");
		    e.printStackTrace ();
		    error (false);
		}

	    } catch (Exception e) {
		System.out.println ("** Exception:  " + e);
		e.printStackTrace ();
		error (false);
	    }
	}

	System.out.println ("PASS !!!");
	System.out.println ("");
    }
}
