/*
 * @(#)certTest.java	1.3 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.io.*;
import java.util.Date;

import sun.security.x509.*;

/**
 * Just compile this class locally and run it on certs/*.cer.
 * 
 * This is a class used to test the X.509 cert parsing code.  It's
 * going to undergo mitosis later, and not be an accidental part
 * of the software distribution.
 */
public class certTest {

    public static void main (String argv []) {
	int i;
/*

	if (argv.length == 0) {
	    X509Cert	x1, x2;

	    try {
		KeyGen		keypair = KeyGen.makeKeyGen ("DSA");

		X500Name	subject;
		Signer		issuer;
		byte		cert [];

		subject = new X500Name ("Zaphod Beeblebrox",
			"Transgalactic Inc.", "Ursa Major", "US");
	
		x1 = keypair.getSelfCert (subject,
		    60		// seconds per minute
		    * 60	// minutes per hour
		    * 24	// hours per day
		    * 28	// days per month (more or less)
		    * 6		// months
		    );
		cert = x1.getSignedCert ();
		x2 = new X509Cert (cert);

 		System.out.println ("New Cert:  " + x2);

		x1.verify (keypair.getPublicKey ());
		x2.verify (keypair.getPublicKey ());

		if (!x1.equals (x2))
		    System.out.println ("?? x1 != x2 ??");
{
    FileOutputStream out = new FileOutputStream ("/tmp/zz.cer");
    out.write (cert);
    out.close ();
}

	    } catch (Exception e) {
		System.out.println ("Exception:  " + e);
		e.printStackTrace ();
		return;
	    }

	    System.out.println ("Constructed and verified an X.509 cert!");
	    return;
	}
*/

	/*
	 * Read in a bunch of cert files, parse them, validate
	 * those that stand a chance of being valid.
	 */
	Date	now = new Date ();
	
	for (i = 0; i < argv.length; i++) {
	    
	    String certFile = argv [i];
	    
	    byte		certdata [] = null;

	    try {
		//
		// Read the cert in from the file.
		//
		{
		    InputStream	is;
		    int		len;

		    is = new FileInputStream (certFile);
		    len = is.available ();
		    certdata = new byte [len];

		    if (is.read (certdata) != len) {
			System.out.println ("** short read of cert");
			return;
		    }

		    is.close ();
		}


		//
		// Parse and print the cert
		//
		X509Cert	cert = new X509Cert (certdata);

		System.out.println ("-----------------------");
		System.out.println ("Cert File = " + certFile);
		System.out.println (cert);

		//
		// Check for self-signed certs; try to validate them.
		// Valid certs expire, so we cope with that case.  All
		// other cases indicate some kind of error ... such as
		// the cert file having garbage at the end.
		//
		try {
		    if (cert.getSubjectName().equals (cert.getIssuerName ())) {
			cert.verify (cert.getPublicKey ());
			System.out.println ("  ++ Cert self-verifies!");
		    } else 
			System.out.println ("  == Cert not self-signed");
		} catch (CertException e) {
		    if (e.getVerfCode ()
			    == CertException.verf_INVALID_EXPIRED)
			System.out.println ("  -- Cert expired");
		    else {
			System.out.println ("  -- Cert doesn't self-verify!");
			e.printStackTrace ();
		    }
		} catch (Exception e) {
		    System.out.println ("  -- Error during verify!");
		    e.printStackTrace ();
		}

	    } catch (Exception e) {
		System.out.println ("** Exception:  " + e);
		e.printStackTrace ();
		return;
	    }
	}
    }
}
