/*
 * @(#)TestParsePKCS7.java	1.3 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.io.*;
import java.security.*;

import sun.security.pkcs.*;
import sun.security.util.*;

public class TestParsePKCS7 {

    static File file;

    public static void main(String[] args) {
	if (args.length != 1) {
	    System.err.println("usage: java TestPKCSParse <file.pkcs>");
	    System.exit(1);
	}

	file = new File(args[0]);

	if (!file.exists()) {
	    System.err.println("cannot find file: " + file);
	    System.exit(1);
	}

	try {
	    FileInputStream fis = new FileInputStream(file);
	    DataInputStream dis = new DataInputStream(fis);
	    byte[] data = new byte[dis.available()];
	    dis.readFully(data);
	    
	    PKCS7 pkcs = new PKCS7(new DerInputStream(data));
	    
	    System.err.println(pkcs);

	} catch (Exception e) {
	    e.printStackTrace();
	}
    }
}
    
