/*
 * @(#)ArrayOpsTest.java	1.3 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import PrimitivesTest;

class ArrayOpsTest {
    public static boolean verify(int a[], int b[]) {
	boolean result = true;
	
	if (a.length != b.length) {
	    System.out.println("Int array lengths differ: " +
			       a.length + " != " + b.length);
	    result = false;
	}
	
	for (int i = 0; i < a.length; i++){
	    if (a[i] != b[i] ) {
	    System.out.println("Int array contents differ at index " + i + ": " +
			       a[i] + " != " + b[i]);
	    result = false;
	    }
	}
	return result;
    }
    
    public static boolean verify(byte a[], byte b[]) {
	boolean result = true;
	
	if (a.length != b.length) {
	    System.out.println("Byte array lengths differ: " +
			       a.length + " != " + b.length);
	    result = false;
	}
	
	for (int i = 0; i < a.length; i++){
	    if (a[i] != b[i] ) {
	    System.out.println("Byte array contents differ at index " + i + ": " +
			       a[i] + " != " + b[i]);
	    result = false;
	    }
	}
	return result;
    }

    public static boolean verify(char a[], char b[]) {
	boolean result = true;
	
	if (a.length != b.length) {
	    System.out.println("Char array lengths differ: " +
			       a.length + " != " + b.length);
	    result = false;
	}
	
	for (int i = 0; i < a.length; i++){
	    if (a[i] != b[i] ) {
	    System.out.println("Char array contents differ at index " + i + ": " +
			       a[i] + " != " + b[i]);
	    result = false;
	    }
	}
	return result;
    }
    
    public static boolean verify(short a[], short b[]) {
	boolean result = true;
	
	if (a.length != b.length) {
	    System.out.println("Short array lengths differ: " +
			       a.length + " != " + b.length);
	    result = false;
	}
	
	for (int i = 0; i < a.length; i++){
	    if (a[i] != b[i] ) {
	    System.out.println("Short array contents differ at index " + i + ": " +
			       a[i] + " != " + b[i]);
	    result = false;
	    }
	}
	return result;
    }
    
    public static boolean verify(boolean a[], boolean b[]) {
	boolean result = true;
	
	if (a.length != b.length) {
	    System.out.println("Boolean array lengths differ: " +
			       a.length + " != " + b.length);
	    result = false;
	}
	
	for (int i = 0; i < a.length; i++){
	    if (a[i] != b[i] ) {
	    System.out.println("Boolean array contents differ at index " + i + ": " +
			       a[i] + " != " + b[i]);
	    result = false;
	    }
	}
	return result;
    }
    
    public static boolean verify(float a[], float b[]) {
	boolean result = true;
	
	if (a.length != b.length) {
	    System.out.println("Float array lengths differ: " +
			       a.length + " != " + b.length);
	    result = false;
	}
	
	for (int i = 0; i < a.length; i++){
	    if (a[i] != b[i] ) {
	    System.out.println("Float array contents differ at index " + i + ": " +
			       a[i] + " != " + b[i]);
	    result = false;
	    }
	}
	return result;
    }
    
    public static boolean verify(double a[], double b[]) {
	boolean result = true;
	
	if (a.length != b.length) {
	    System.out.println("Double array lengths differ: " +
			       a.length + " != " + b.length);
	    result = false;
	}
	
	for (int i = 0; i < a.length; i++){
	    if (a[i] != b[i] ) {
	    System.out.println("Double array contents differ at index " + i + ": " +
			       a[i] + " != " + b[i]);
	    result = false;
	    }
	}
	return result;
    }
    
    public static boolean verify(long a[], long b[]) {
	boolean result = true;
	
	if (a.length != b.length) {
	    System.out.println("Long array lengths differ: " +
			       a.length + " != " + b.length);
	    result = false;
	}
	
	for (int i = 0; i < a.length; i++){
	    if (a[i] != b[i] ) {
	    System.out.println("Long array contents differ at index " + i + ": " +
			       a[i] + " != " + b[i]);
	    result = false;
	    }
	}
	return result;
    }

   public static boolean verify(String a[], String b[]) {
	boolean result = true;
	
	if (a.length != b.length) {
	    System.out.println("String array lengths differ: " +
			       a.length + " != " + b.length);
	    result = false;
	}
	
	for (int i = 0; i < a.length; i++){
	    if (!a[i].equals(b[i])) {
	    System.out.println("String array contents differ at index " + i + ": " +
			       a[i] + " != " + b[i]);
	    result = false;
	    }
	}
	return result;
    }

   public static boolean verify(PrimitivesTest a[], PrimitivesTest b[]) {
	boolean result = true;
	
	if (a.length != b.length) {
	    System.out.println("PrimitivesTest array lengths differ: " +
			       a.length + " != " + b.length);
	    result = false;
	}
	
	for (int i = 0; i < a.length; i++){
	    if (a[i] == null && b[i] == null)
		continue;
	    
	    if (!a[i].equals(b[i])) {
	    System.out.println("PrimitivesTest array contents differ at index " + i + ": " +
			       a[i] + " != " + b[i]);
	    result = false;
	    }
	}
	return result;
    }
    
}
