/*
 * @(#)ArrayTest.java	1.3 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import ArrayOpsTest;
import PrimitivesTest;


class ArrayTest implements java.io.Serializable {

    byte b[] = { 0, 1};
    short s[] = { 0, 1, 2};
    char c[] = { 'Z', 'Y', 'X'};
    int i[] = { 0, 1, 2, 3, 4};
    long l[] = { 0, 1, 2, 3, 4, 5};
    boolean z[] = new boolean[4];
    float f[] = { 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f};
    double d[] = { 1.0d, 2.0d, 3.0d, 4.0d, 5.0d, 6.0d, 7.0d};
    String string[] = { "ABC", "DEF", "GHI", "JKL"};
    PrimitivesTest prim[] = { new PrimitivesTest(), new PrimitivesTest() } ;

    transient int ti[] =  {99, 98, 97, 96};
    ArrayTest self = this;

    static  int si[] = {9, 8, 7, 6, 4} ;

    public ArrayTest() {
	z[0] = true;
	z[1] = false;
	z[2] = true;
	z[3] = false;
    }

    public boolean equals(ArrayTest other) {
	boolean ret = true;
	
	if (other == null) {
	    System.out.println("other Array is " + other);
	    return false;
	}
	
	if (!ArrayOpsTest.verify(i, other.i)) {
	    System.out.println("Unpickling of int array failed");
	    ret = false;
	}

	if (!ArrayOpsTest.verify(b, other.b)) {
	    System.out.println("Unpickling of byte array failed");
	    ret = false;
	}
	if ( !ArrayOpsTest.verify(s, other.s)) {
	    System.out.println("Unpickling of short array failed");
	    ret = false;
	}
	if ( !ArrayOpsTest.verify(c, other.c)) {
	    System.out.println("Unpickling of char array failed");
	    ret = false;
	}
	if ( !ArrayOpsTest.verify(l, other.l)) {
	    System.out.println("Unpickling of long array failed");
	    ret = false;
	}
	if ( !ArrayOpsTest.verify(f, other.f)) {
	    System.out.println("Unpickling of float array failed");
	    ret = false;
	}
	if ( !ArrayOpsTest.verify(d, other.d)) {
	    System.out.println("Unpickling of double array failed");
	    ret = false;
	}
	if ( !ArrayOpsTest.verify(z, other.z)) {
	    System.out.println("Unpickling of boolean array failed");
	    ret = false;
	}
	if ( !ArrayOpsTest.verify(string, other.string)) {
	    System.out.println("Unpickling of String array failed");
	    ret = false;
	}
	if (!ArrayOpsTest.verify(prim, other.prim)) {
	    System.out.println("Unpickling of Primitives array failed");
	    ret = false;
	}
	return ret;
	
    }
}
