/*
 * @(#)BinaryTreeTest.java	1.3 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
class BinaryTreeTest implements java.io.Serializable {
    public BinaryTreeTest left;
    public BinaryTreeTest right;
    public int id;
    public int level;

    private static int count = 0;
    public BinaryTreeTest(int l) {
	id = count++;
	level = l;
	if (l > 0) {
	    left = new BinaryTreeTest(l-1);
	    right = new BinaryTreeTest(l-1);
	}
    }
    public void print(int levels) {
	for (int i = 0; i < level; i++)
	    System.out.print("  ");
	System.out.println("node " + id);

	if (level <= levels && left != null)
	    left.print(levels);

	if (level <= levels && right != null)
	    right.print(levels);
    }

    public boolean equals(BinaryTreeTest other) {

	if (other == null)
	    return false;

	if (id != other.id)
	    return false;

	if (left != null && !left.equals(other.left))
	    return false;

	if (right != null && !right.equals(other.right))
	    return false;

	return true;
    }
}
