/*
 * @(#)HashtableTest.java	1.2 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.io.*;
import java.util.Hashtable;
import java.util.Enumeration;

class HashtableTest implements java.io.Serializable {
    int id;

    HashtableTest(int i) {
	id = i;
    }

    public String toString() {
	return "id = " + id;
    }

    /** Test that hashtables are correctly deserialized.
     */
    final static int max = 17;	// Number of entries to make in the hashtable

    public static void main (String argv[]) {
	Hashtable h = new Hashtable(101);
	int i;

	// Populate the hash with known keys and objects
	for (i = 0; i < max; i++ ) {
	    Object key = new HashtableTest(i);
	    Object value = new Integer(i);
	    h.put(key, value);
	}

	FileInputStream istream = null;
	try {
	    FileOutputStream ostream = new FileOutputStream("HashtableTest.tmp");
	    ObjectOutputStream p = new ObjectOutputStream(ostream);
	    p.writeObject(h);
	    p.flush();

	    istream = new FileInputStream("HashtableTest.tmp");
	    ObjectInputStream q = new ObjectInputStream(istream);

	    Hashtable h_result = (Hashtable)q.readObject();

	    // Verify that there are max entries in the table
	    if (h_result.size() != max) {
		System.out.println("Length != max, is " + h_result.size());
	    }

	    // Verify that each entry is still there and has the right value.
	    int count = 0;
	    Integer[] elements = new Integer[h_result.size()];
	    for (Enumeration e = h_result.elements(); e.hasMoreElements() ;) {
		count++;
		Integer elem = (Integer)e.nextElement();
		if (!h_result.contains(elem))
		    System.out.println("Result does not contain member " + elem);

		if (elements[elem.intValue()] != null)
		    System.err.println("Duplicate element " + elem);
		elements[elem.intValue()] = elem;
	    }
	    if (count != h_result.size())
		System.out.println("Element count = " + count + " should be " + h_result.size());
	    for (i = 0; i < elements.length; i++) {
		if (elements[i] == null)
		    System.err.println("Missing element " + i);
	    }

	    // Verify that each key is still there and has the right value.
	    count = 0;
	    HashtableTest[] keys = new HashtableTest[h_result.size()];
	    for (Enumeration e = h_result.keys() ; e.hasMoreElements() ;) {
		count++;
		HashtableTest elem = (HashtableTest)e.nextElement();
		if (!h_result.containsKey(elem)) {
		    System.out.println("Result does not contain key " + elem);
		    System.out.println("\t " + elem.hashCode());
		}
		if (keys[elem.id] != null)
		    System.err.println("Duplicate key " + elem);
		keys[elem.id] = elem;
	    }
	    if (count != h_result.size())
		System.out.println("Key count = " + count + " should be " + h_result.size());
	    for (i = 0; i < keys.length; i++) {
		if (keys[i] == null)
		    System.err.println("Missing key " + i);
	    }
	}
	catch (Exception e) {
	    e.printStackTrace();
	    System.out.println("Input remaining");
	    int ch;
	    try {
		while ((ch = istream.read()) != -1)
		    System.out.print(Integer.toString(ch, 16)+ " ");
		System.out.println();
		
	    } catch (Exception f) {
	    }
	    
	}
    }
}

