/*
 * @(#)IntegerTest.java	1.2 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.io.*;

class IntegerTest implements java.io.Serializable {

    /**
     * Test that instances of the Integer class are written and read correctly
     */
    public static void main (String argv[]) {
	Integer a = new Integer(5);

	FileInputStream istream = null;
	try {
	    FileOutputStream ostream = new FileOutputStream("_integertest.tmp");
	    ObjectOutputStream p = new ObjectOutputStream(ostream);
	    p.writeObject(a);
	    p.flush();

	    istream = new FileInputStream("_integertest.tmp");
	    ObjectInputStream q = new ObjectInputStream(istream);

	    Integer a_result = (Integer)q.readObject();

	    if (!a.equals(a_result)) {
		System.out.println("Integer test failed");
		System.out.println("a = " + a);
		System.out.println("a_result = " + a_result);
	    }
	}
	catch (Exception e) {
	    e.printStackTrace();
	    System.out.println("Input remaining");
	    int ch;
	    try {
		while ((ch = istream.read()) != -1)
		    System.out.print(Integer.toString(ch, 16)+ " ");
		System.out.println();
		
	    } catch (Exception f) {
	    }
	    
	}
    }
}

